/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfNegate.h
 * @brief MGSurfNegateTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFNEGATE_H__32FB5B98_5762_42F2_A9C8_1B381ECD9F2C__INCLUDED_)
#define AFX_SURFNEGATE_H__32FB5B98_5762_42F2_A9C8_1B381ECD9F2C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGSurfNegateTool SurfNegate.h SurfCmd/SurfNegate.h
///
/// Reverses a surface's direction.
class MGSurfNegateTool : public MGSelectState{
public:
	explicit MGSurfNegateTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
};

#endif // !defined(AFX_SURFNEGATE_H__32FB5B98_5762_42F2_A9C8_1B381ECD9F2C__INCLUDED_)
