/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfCornersTool.h
 * @brief MGSurfCornersTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFCORNERSTOOL_H__AB8BBAAE_4CED_44C5_9FD5_AA99C4D90AFD__INCLUDED_)
#define AFX_SURFCORNERSTOOL_H__AB8BBAAE_4CED_44C5_9FD5_AA99C4D90AFD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGSurfCornersTool SurfCornersTool.h SurfCmd/SurfCornersTool.h
///
/// Creates a plan surface by the corner points.
class MGSurfCornersTool : public MGLocateState
{
	std::unique_ptr<MGSurface> m_spPreview; ///< vr[f[^

public:
	explicit MGSurfCornersTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	void prompt_message() const;
	MGSurface* Compute(fugenView* pView, const MGPosition& pos);
};

#endif // !defined(AFX_SURFCORNERSTOOL_H__AB8BBAAE_4CED_44C5_9FD5_AA99C4D90AFD__INCLUDED_)
