/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file RectVertTool.h
 * @brief MGRectVertTool NX̃C^[tFCX
 */
#if !defined(AFX_RECTVERTTOOL_H__89D04920_0F0F_4CD7_AAA5_21B3F20FCCA4__INCLUDED_)
#define AFX_RECTVERTTOOL_H__89D04920_0F0F_4CD7_AAA5_21B3F20FCCA4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGRectVertToolBase RectVertTool.h "SurfCmd/RectVertTool.h"
/// lp` - uCPlane ɐȖʁvV[Y
class MGRectVertToolBase : public MGLocateState{
public:
	MGRectVertToolBase(fugenDoc* pDoc, int nCmdID);
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	void prompt_message() const;

protected:
	virtual void make_model() = 0;
	
private:
};

/// @class MGRectFaceVertTool RectVertTool.h "SurfCmd/RectVertTool.h"
///
/// Creates a rectangle face vertical to the construction plane. 
class MGRectFaceVertTool : public MGRectVertToolBase{
public:
	explicit MGRectFaceVertTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void make_model();
};

/// @class MGPlaneVertTool RectVertTool.h "SurfCmd/RectVertTool.h"
///
/// Creates a plane vertical to the construction plane. 
class MGPlaneVertTool : public MGRectVertToolBase{
public:
	explicit MGPlaneVertTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void make_model();
};

//Build rectangle's 4 corner points in corners.
void buildRectPointsFrom3Points(
	const MGPosition& P0,///< 1st corner data
	const MGPosition& P1,///< 2nd corner data
	const MGPosition& P2,///< 3rd point data
	MGPosition corners[4]
);

#endif // !defined(AFX_RECTVERTTOOL_H__89D04920_0F0F_4CD7_AAA5_21B3F20FCCA4__INCLUDED_)
