/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#pragma once

#include "mgModelessDialogue.h"
class MGEvalSurfGaussTool;

/////////////////////////////////////////////////////////////////////////////
// CSrfCurvaDlg _CAO

class CSrfCurvaDlg : public mgModelessDialogue{
	friend class MGEvalSurfGaussTool;

	// _CAO f[^
		//{{AFX_DATA(CSrfCurvaDlg)
	double	m_dMin;
	double	m_dMax;
	CString	m_strMean;
	//}}AFX_DATA

	TRIVERTEX m_vert[5];
	GRADIENT_RECT m_gr[4];
	BOOL m_bModified;

public:
	// RXgNV
	CSrfCurvaDlg(MGEvalSurfGaussTool* tool);

	MGCL::SURFACE_CURVATURE_KIND GetCurvaKind() const;
	double GetRangeMax() const{ return m_dMax;}
	double GetRangeMin() const{ return m_dMin;}
	BOOL IsModified() const{ return m_bModified;}
	void SetModifiedFlag(BOOL bModified = TRUE){ m_bModified = bModified;}
	MGEvalSurfGaussTool * getEvalSurfGaussToolPointer();

// I[o[Ch
	//{{AFX_VIRTUAL(CSrfCurvaDlg)
protected:
	virtual BOOL OnInitDialog();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual void OnOK();
	//}}AFX_VIRTUAL

// Cve[V
protected:
	//{{AFX_MSG(CSrfCurvaDlg)
	afx_msg void OnPaint();
	afx_msg void OnUpdateEditCtrl();
	afx_msg void ResetAutoRange();
	afx_msg void ResetMinMaxRange();
	afx_msg void OnBtnRefresh();
	//}}AFX_MSG

private:
	void UpdateGradientArea();
	void UpdateShadingView();

	DECLARE_MESSAGE_MAP()
};
