/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// SplitChildFrame.cpp : Cve[V t@C

#include "stdafx.h"
#include "fugen.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "SplitChildFrame.h"
#include "fugenView2Dxy.h"
#include "fugenView2Dyz.h"
#include "fugenView2Dxz.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSplitChildFrame

IMPLEMENT_DYNCREATE(CSplitChildFrame, CMDIChildWnd)

CSplitChildFrame::CSplitChildFrame(){
}

CSplitChildFrame::~CSplitChildFrame(){
}

BOOL CSplitChildFrame::PreCreateWindow(CREATESTRUCT& cs){
	if(!CMDIChildWnd::PreCreateWindow(cs))
		return FALSE;

	UserPreference& pref = UserPreference::getInstance();
	if(pref.GetBoolValue(upv_Window_InitChildMaximum)){
		cs.style |= WS_VISIBLE | WS_MAXIMIZE;
	}
	return TRUE;
}

BEGIN_MESSAGE_MAP(CSplitChildFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CSplitChildFrame)
	ON_WM_CLOSE()
	ON_COMMAND(ID_FRAME_SPLIT, OnFrameSplit)
	ON_UPDATE_COMMAND_UI(ID_FRAME_SPLIT, OnUpdateFrameSplit)
	//}}AFX_MSG_MAP

END_MESSAGE_MAP()

CDocument* CSplitChildFrame::GetDoc()
{
	CView* pView = static_cast<CView*>(m_wndSplitter.GetPane(0, 0));
	return pView->GetDocument();
}

/////////////////////////////////////////////////////////////////////////////
// CChildFrame NX̐ff

#ifdef _DEBUG
void CSplitChildFrame::AssertValid() const{
	CMDIChildWnd::AssertValid();
}

void CSplitChildFrame::Dump(CDumpContext& dc) const{
	CMDIChildWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSplitChildFrame bZ[W nh

void CSplitChildFrame::OnClose()
{
	// ő剻tOXV
	UserPreference& pref = UserPreference::getInstance();
	const DWORD dwStyle = GetStyle();
	const DWORD dwFlags = WS_MAXIMIZE;
	const bool bMaximize = ((dwStyle & dwFlags) == dwFlags);
	pref.SetBoolValue(upv_Window_InitChildMaximum, bMaximize);

	// Fix #566: ɔhqEBhEB

	CMDIChildWnd* child = this;
	CDocument* pDoc = GetDoc();
	do{
		if(child != this){
			CMDIChildWnd* wnd = child;
			child = static_cast<CMDIChildWnd*>(wnd->GetWindow(GW_HWNDNEXT));
			if(wnd && wnd->GetActiveView()->GetDocument() == pDoc){
				// wnd 
				wnd->MDIDestroy();
			}
		}
		else{
			child = static_cast<CMDIChildWnd*>(child->GetWindow(GW_HWNDNEXT));
		}
	}
	while(child);

	CMDIChildWnd::OnClose();
}

BOOL CSplitChildFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext){

	m_bIsSplit = FALSE;
	return m_wndSplitter.CreateStaticEx(this, 2, 2, pContext);

// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
//	return m_wndSplitter.Create(this,
//	2, 2,       // TODO: sƗ̐𒲐ĂB
//	CSize(10, 10),  // TODO: ŏ̋TCY𒲐ĂB
//	pContext);
	
//	return CMDIChildWnd::OnCreateClient(lpcs, pContext);
}

void CSplitChildFrame::OnFrameSplit(){
	CView* pMainView;
	fugenDoc* doc;
	if(m_bIsSplit){
		pMainView = (fugenView*)m_wndSplitter.GetPane(0,1);
		doc=(fugenDoc*)pMainView->GetDocument();
		doc->save_view_context();

		//ȂȂr[̍폜
		m_wndSplitter.GetPane(0,0)->DestroyWindow();
		m_wndSplitter.GetPane(1,0)->DestroyWindow();
		m_wndSplitter.GetPane(1,1)->DestroyWindow();

		pMainView->SetDlgCtrlID(m_wndSplitter.IdFromRowCol(0,0));
		m_wndSplitter.ResetViewNums(1,1);
	}else{
		m_wndSplitter.ResetViewNums(2,2);

		CCreateContext context;
		// if no context specified, generate one from the currently selected
		//  client if possible
		pMainView = (fugenView*)m_wndSplitter.GetPane(0,0);
		if (pMainView != NULL && pMainView->IsKindOf(RUNTIME_CLASS(CView))){
			// set info about last pane
			ASSERT(context.m_pCurrentFrame == NULL);
			context.m_pLastView = pMainView;
			context.m_pCurrentDoc = pMainView->GetDocument();
			if (context.m_pCurrentDoc != NULL)
				context.m_pNewDocTemplate = context.m_pCurrentDoc->GetDocTemplate();
		}
		//Main̈ʒuύX
		doc=(fugenDoc*)pMainView->GetDocument();
		doc->save_view_context();
		pMainView->SetDlgCtrlID(m_wndSplitter.IdFromRowCol(0,1));

		//(0,0)
		context.m_pNewViewClass = RUNTIME_CLASS(fugenView2Dxy);
		m_wndSplitter.CreateView(0,0, RUNTIME_CLASS(fugenView2Dxy), CSize(0,0), &context);
//		m_wndSplitter.GetPane(0,1)->PostMessage();

		//(1,0)
		context.m_pNewViewClass = RUNTIME_CLASS(fugenView2Dyz);
		m_wndSplitter.CreateView(1,0, RUNTIME_CLASS(fugenView2Dyz), CSize(0,0), &context);

		//(1,1)
		context.m_pNewViewClass = RUNTIME_CLASS(fugenView2Dxz);
		m_wndSplitter.CreateView(1,1, RUNTIME_CLASS(fugenView2Dxz), CSize(0,0), &context);

		InitialUpdateFrame(doc, TRUE);

		//Set up grid snap modes of all the view.
		const MGSnapAttrib& snapAtrib=doc->getSnapAttr();
		doc->enableGridSnap(snapAtrib.getGrid());
	}
	m_wndSplitter.RecalcViewSize();
	m_wndSplitter.RecalcLayout();
	m_bIsSplit = !m_bIsSplit;
}

void CSplitChildFrame::OnUpdateFrameSplit(CCmdUI* pCmdUI){
	pCmdUI->SetCheck(m_bIsSplit);
}
