/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#if !defined(AFX_SMOOTHINGDLG_H__1DEF6FE1_B2F5_4F81_AC9E_6BA037CEEA85__INCLUDED_)
#define AFX_SMOOTHINGDLG_H__1DEF6FE1_B2F5_4F81_AC9E_6BA037CEEA85__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mgModelessDialogue.h"

class MGCurveSmoothingState;

/////////////////////////////////////////////////////////////////////////////
// CSmoothingDlg _CAO

class CSmoothingDlg : public mgModelessDialogue{

// RXgNV
public:

	//Dialogue id=IDD_SMOOTHING_DLG.
	CSmoothingDlg(MGCurveSmoothingState* tool);

	//  DDV/DDX f[^
	double m_dScaleMin, m_dScaleMax;///<minimum/maximum of m_dScale(graph length scale).
	int m_nDensMin, m_nDensMax;///<minimum/maximum of m_nDensity(graph draw density).

// _CAO f[^
	//{{AFX_DATA(CSmoothingDlg)
	double	m_dWeight;//weight value for each points.
					//When subtract mode, -m_dWeight will be added.
	double	m_dMaxDev;
	BOOL m_bFixStart;//TRUE if start point should be fixed.
	BOOL m_bFixEnd;	//TRUE if end point should be fixed.
	int m_nDevKind; //TRUE if mean deviation, FALSE if maximum deviation.
	int m_nEndKind; //0: Free-end; 1: Keep

	CSpinButtonCtrl m_spnScale;
	double	m_dScale;

	CSpinButtonCtrl m_spnDens;
	int m_nDensity;///<graph draw density.

	int	m_iType; //0: curvature, 1:radius of curvature.
	BOOL m_bNegate;///True if curvature is outer and curvature radius is inner.
	//}}AFX_DATA

	double GetScale() const;

	virtual void OnCancel();
	virtual void OnOK();

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CSmoothingDlg)
public:
	BOOL OnInitDialog() override;
	BOOL PreTranslateMessage(MSG* pMsg) override;
	void DoDataExchange(CDataExchange* pDX) override;    // DDX/DDV T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CSmoothingDlg)
	afx_msg void OnDeltaposSpin(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCurvaSmoothFixStart();
	afx_msg void OnCurvaSmoothFixEnd();
	afx_msg void UpdateView();//Get the data from the dialogue and redraw the view by the new data.
	//}}AFX_MSG

private:
	void LoadUserPref();
	void SaveUserPref() const;

	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_SMOOTHINGDLG_H__1DEF6FE1_B2F5_4F81_AC9E_6BA037CEEA85__INCLUDED_)
