/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// SliderDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "SliderDlg.h"
#include "fugenDoc.h"
#include "CurveCmd/CurveBlendTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSliderDlg _CAO


CSliderDlg::CSliderDlg(MGCurveBlendTool* tool)
: mgModelessDialogue(tool){
	//{{AFX_DATA_INIT(CSliderDlg)
	m_slider1 = 0;
	m_slider2 = 0;
	//}}AFX_DATA_INIT
	Create(IDD_2SLD_DLG);
}

BOOL CSliderDlg::OnInitDialog(){
	mgModelessDialogue::OnInitDialog();

	CSliderCtrl* pSlider = static_cast<CSliderCtrl*>(GetDlgItem(IDC_SLIDER1));
	pSlider->SetRange(5, 50);

	pSlider = static_cast<CSliderCtrl*>(GetDlgItem(IDC_SLIDER2));
	pSlider->SetRange(5, 50);

	return TRUE;
}

void CSliderDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSliderDlg)
	DDX_Slider(pDX, IDC_SLIDER1, m_slider1);
	DDX_Slider(pDX, IDC_SLIDER2, m_slider2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSliderDlg, CDialog)
	//{{AFX_MSG_MAP(CSliderDlg)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSliderDlg bZ[W nh

BOOL CSliderDlg::PreTranslateMessage(MSG* pMsg) {
	switch(pMsg->message){
	case WM_MOUSEWHEEL:
		return -1;
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CSliderDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar){
	MGCurveBlendTool* tool =
		static_cast<MGCurveBlendTool*>(getCmdTool());
	if(tool)
		tool->draw_temporary();

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
