/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 *  @file   GLPrinter.h
 *  @brief  Declaration for class fugenPrinter.
 */
#if !defined(__GLPRINT_H__)
#define __GLPRINT_H__

#include "mgGL/openglView.h"
#include "GLDibOperation.h"

class fugenView;

/**
 *  @brief This class manages print preview. 
 *
 *  Declaration for class fugenPrinter.
 *  Auxiliary functions to print out images OpenGL draws.
 *  
 *  @sa     fugenView
 */
class fugenPrinter{

// Constructors
public:
	/// Creates a printer object. The default constructor.
	fugenPrinter();

	/// The destructor
	/// Destroys the object and deletes this resources.
	~fugenPrinter();

private:
	// Disable the copy constructor and assignment operator.
	fugenPrinter(const fugenPrinter&);
	fugenPrinter& operator =(const fugenPrinter&);

	void setUpDIB(
			const CRect& rcClient,//display target windowCRect͂
			CDC* pDC,///<PrinterDC
			CPrintInfo* pInfo
		);
	void endUpDIB(fugenView* pView);

// Implementation
//protected:
public:

	/// call by CView::OnBeginPrinting
	void OnBeginPrinting(
		fugenView* pView,///<printΏۂ̉
		CDC* pDC,///<PrinterDC
		CPrintInfo* pInfo
	);

	/// call by CView::OnEndPrinting
	void OnEndPrinting(fugenView* pView, CDC* pDC, CPrintInfo* pInfo);

	/// call by CView::OnEndPrintPreview
	void OnEndPrintPreview(
		fugenView* pView,
		CDC*           pDC,
		CPrintInfo*    pInfo,
		POINT          point,
		CPreviewView*  pPreviewView
		);

	/// call by CView::OnPrepareDC
	void OnPrepareDC(fugenView* pView, CDC* pDC, CPrintInfo* pInfo);

	/// call by CView::OnPreparePrinting
	BOOL OnPreparePrinting(fugenView* pView, CPrintInfo* pInfo);


	/// call by CView::OnPrint
	void OnPrint(fugenView* pView, CDC* pDC, CPrintInfo* pInfo);

	/////Set the owner of this fugenPrinter.
	//void activate_parent();
	/////Deaactivate the owner of this fugenPrinter.
	//void deactivate_parent();
	///Set the owner of this fugenPrinter.
	void set_owner_COpenGLWindow(fugenView* pView);

private:
	// Call after MGOpenGLView::drawScene().
	void PostRenderScene(fugenView* pView, CDC* pDC, CPrintInfo* pInfo);

// Member Data
private:
//	MGOpenGLView   m_printer_glview; //!< This member valiable should be the first.
	CGLDibOperation m_dibImpl;
	CSize          m_szPage;
	fugenView* m_pView;      //!< The owner view.
	float          m_fScreenScale;
//	mgGLSLProgram m_glsl;
};

#endif // __GLPRINT_H__
