/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno             */
/* All rights reserved.                                             */
/* **************************************************************** */

// UserPrefValue.h
#pragma once

/// A user preference value of type boolean.
struct UserPrefBoolValue{
	LPCTSTR section; ///< registry section name
	LPCTSTR entry; ///< registry entry name
	bool def; ///< default value
	bool value; ///< preferred value

	UserPrefBoolValue();
	UserPrefBoolValue(LPCTSTR s, LPCTSTR e, bool v);
};

/// A user preference value of type integer.
struct UserPrefIntValue{
	LPCTSTR section; ///< registry section name
	LPCTSTR entry; ///< registry entry name
	int def; ///< default value, which must be in range [lower, upper].
	int value; ///< preferred value, which must be in range [lower, upper].
	int lower; ///< lower bound
	int upper; ///< upper bound

	UserPrefIntValue();
	UserPrefIntValue(LPCTSTR s, LPCTSTR e, int v, int l, int u);
};

/// A user preference value of type double.
struct UserPrefDoubleValue{
	LPCTSTR section; ///< registry section name
	LPCTSTR entry; ///< registry entry name
	double def; ///< default value, which must be in range [lower, upper].
	double value; ///< preferred value, which must be in range [lower, upper].
	double lower; ///< lower bound
	double upper; ///< upper bound

	UserPrefDoubleValue();
	UserPrefDoubleValue(LPCTSTR s, LPCTSTR e, double v, double l, double u);
};

/// A user preference value of type string.
struct UserPrefStringValue{
	LPCTSTR section; ///< registry section name
	LPCTSTR entry; ///< registry entry name
	CString def; ///< default value
	CString value; ///< preferred value

	UserPrefStringValue();
	UserPrefStringValue(LPCTSTR s, LPCTSTR e, const CString& v);
};
