/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno             */
/* All rights reserved.                                             */
/* **************************************************************** */

// UserPrefValue.cpp
#include "stdafx.h"
#include "Misc/UserPrefValue.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Bool

UserPrefBoolValue::UserPrefBoolValue(){
}

UserPrefBoolValue::UserPrefBoolValue(LPCTSTR s, LPCTSTR e, bool v)
: section(s), entry(e), def(v), value(v){
	ASSERT(def == value);
}

// Int

UserPrefIntValue::UserPrefIntValue(LPCTSTR s, LPCTSTR e, int v, int l, int u)
: section(s), entry(e), def(v), value(v), lower(l), upper(u){
	ASSERT(def == value);
	ASSERT(lower <= upper);
	ASSERT(lower <= value && value <= upper);
}

// Double

UserPrefDoubleValue::UserPrefDoubleValue(){
}

UserPrefDoubleValue::UserPrefDoubleValue(LPCTSTR s, LPCTSTR e, double v, double l, double u)
: section(s), entry(e), def(v), value(v), lower(l), upper(u){
	ASSERT(def == value);
	ASSERT(lower <= upper);
	ASSERT(lower <= value && value <= upper);
}

// String

UserPrefStringValue::UserPrefStringValue(){
}

UserPrefStringValue::UserPrefStringValue(LPCTSTR s, LPCTSTR e, const CString& v)
: section(s), entry(e), def(v), value(v){
	ASSERT(def == value);
}
