/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/**
 *  @file   GLDibOperation.h
 *  @brief  Declaration for class CGLDibOperation.
 */
#if !defined(AFX_GLDIBOPERATION_H__868DDC16_2CD4_4884_9ADD_B0C86E0AB3AD__INCLUDED_)
#define AFX_GLDIBOPERATION_H__868DDC16_2CD4_4884_9ADD_B0C86E0AB3AD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mgGL/mgGLFrameBufferObject.h"

/**
 *  @brief This class encapsulates DIB operation.
 *
 *  Declaration for class CGLDibOperation.
 *  p菇͎̂ƂF
 * (1) Createɂ菉
 * (2) ΏۂfugenViewmake_RC_current
 * (3) beginRender()M
 * (4) `揈(MGOpenGLView::drawScene()Ȃǁj
 * (5) endRender()M
 * (6) ΏۂfugenViewrelease_dc()
 */
class CGLDibOperation{
public:

/// Constructor
CGLDibOperation();

/// Destructor
~CGLDibOperation();

//@{
int GetBmpWidth() const{ return m_bmi.bmiHeader.biWidth;}
int GetBmpHeight() const{ return m_bmi.bmiHeader.biHeight;}
//@}

/**
 * @brief Free (system) resources associated with the object.
 * Delete the memory device context and the bitmap.
 */
void Clear() throw();

/**
 * @brief Create DIB data.
 * @param   hDCSrc        Handle for source image.
 * @param   szDIB         Width and height of DIB image which will be created.
 * @return   Whether the operation is successful, or not.
 */
///hDCSrcPrinterDCAszDIB͈ΏۂWindow size.
bool Create(HDC hDCSrc, const CSize& szDIB);

///beginRender()̑OdrawΏۂCOpenGOWinodwmake_RC_currentKv
void beginRender(){m_FBO.beginRenderTexture();};

///endRender()̌drawΏۂCOpenGOWinodwrelease_dc()Kv
void endRender();

/**
 * @brief Copy pixels in a DIB to the specified destination rectangle.
 * @param   hDCDest   Handle to the destination.
 * @param   offset    Offset from the original image to the destination.
 * @param   target    Size of the destination.
 * @return   Whether the operation is successful, or not.
 */
bool StretchDIBits(HDC hDCDest, const CSize& offset, const CSize& target);

LPVOID  GetPixels(){return m_pBitmapBits;};

private:

// Member data
	HBITMAP    m_hDib;
	BITMAPINFO m_bmi;
	LPVOID     m_pBitmapBits;
	mgGLFramebufferObject m_FBO;

// Disable copy constructor and assignment.
CGLDibOperation(const CGLDibOperation&);
CGLDibOperation& operator=(const CGLDibOperation&);	

};

#endif // !defined(AFX_GLDIBOPERATION_H__868DDC16_2CD4_4884_9ADD_B0C86E0AB3AD__INCLUDED_)
