/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#include "stdafx.h"
#include "resource.h"
#include "IO/GLStlImporter.h"
#include "mg/Group.h"
#include "mg/MGStl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGLStlImporter::CGLStlImporter()
	 : CGLFileImporter(IDS_FILTER_STL)
{
}

bool CGLStlImporter::Load(MGGroup& group)
{
	CString strStlFileName = GetFileName();
	std::unique_ptr<MGStl> stlFile(new MGStl);
	// t@Cǂݍݏ
	if(stlFile->LoadFile((LPCTSTR)strStlFileName)){
		// fail to load file
		return false;
	}

	group.append(stlFile.release());
	return true;
}

bool CGLStlImporter::Load(MGGroup& group, CString fileName)
{
	CString strStlFileName = fileName;
	std::unique_ptr<MGStl> stlFile(new MGStl);
	// t@Cǂݍݏ
	if(stlFile->LoadFile((LPCTSTR)strStlFileName)){
		// fail to load file
		return false;
	}

	group.append(stlFile.release());
	return true;
}
