/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#include "stdafx.h"
#include "mg/MGStl.h"
#include "mg/Group.h"
#include "resource.h"
#include "IO/GLObjImporter.h"
#include "IO/GLStlImporter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGLObjImporter::CGLObjImporter()
	 : CGLFileImporter(IDS_FILTER_OBJ)
{
}

bool CGLObjImporter::Load(MGGroup& group){
	CString fileName = GetFileName();// ǂݍ܂ꂽt@C擾
	buildStl(fileName,group);// objt@Cǂݍstlt@Co͂
	return true;
}

/// objt@CǂݍgroupƂstl쐬Agroupɏo͂
void CGLObjImporter::buildStl(
		const CString& objFilePath,	/// objt@CpX
		MGGroup& group		///Generated stls will be pushed back one obj group by one.
){
    std::ifstream f(objFilePath);
	std::string objData;

	// ǂݍobjf[^Ă
	std::vector<MGPosition> vs;
	std::vector<MGPosition> vns;
	std::vector<int> fs;

	// 1sǂݍŃf[^擾
	// vsɂ́Av 1s̃f[^x,y,zlĂ
	// vnsɂ́Avn 1s̃f[^x,y,zlĂ
	// fsɂ́Af 1s̃f[^x,y,zlAA/ŋ؂l(Op`Ȃ̂3)Ă
	// ڂ́AobjtH[}bgQƂ
    while(getline(f, objData)){
		size_t delpos=objData.find(' ');
		std::string keyword=objData.substr(0,delpos);
		objData.erase(0,delpos+1);
		std::istringstream istrstrm(objData);
		BOOL triangleFlag = true;//
		double xyz[3]={0.,0.,0.};
		if(keyword == "v"){
			for (int i=0; i<3; i++)
				MGCL::get_real(' ',istrstrm,xyz[i]);
			vs.push_back(MGPosition(3,xyz));
		}else if(keyword == "vn"){
			for (int i=0; i<3; i++)
				MGCL::get_real(' ',istrstrm,xyz[i]);
			vns.push_back(MGPosition(3,xyz));
		}else if(keyword == "g"){
			if(fs.size()){
				group.append(new MGStl(vs,fs));
				fs.clear();
			}
		}else if(keyword == "f"){
			//Currrently we process only triangles.
			int triangleId[3];
			for (int i=0; i<3; i++){
				int id=0;
				MGCL::get_integer(' ',istrstrm,id);
				fs.push_back(id);
				triangleId[i]=id;
			}
			int nextStl;
			if(istrstrm >> nextStl){
				fs.push_back(triangleId[0]);
				fs.push_back(triangleId[2]);
				fs.push_back(nextStl);
			}
		}
    }

	// ǂݍobjf[^Astlt@C𐶐	
	if(fs.size()){
		group.append(new MGStl(vs,fs));
	}
}
