/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#include "stdafx.h"
#include "mg/MGStl.h"
#include "mg/Ofstream.h"

#include "resource.h"
#include "IO/GLObjExporter.h"
#include "IO/GLStlExporter.h"
#include "IO/util.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGLObjExporter::CGLObjExporter()
	 : CGLFileExporter(IDS_FILTER_OBJ)
{
}

bool CGLObjExporter::Save(const MGGroup& group){
	// xstlŕۑAstlobjɕϊۑĂ

	// ǂݍ܂ꂽt@C擾
	CString fileName = GetFileName();

	// gqUƂ
	fileName.Replace(_T(".obj"), _T(""));

	// GUID𐶐
	GUID guid;
	::CoCreateGuid(&guid);
	// ɕϊ
	WCHAR ws[40];
	ZeroMemory(ws, sizeof(WCHAR)*40);
	::StringFromGUID2(guid, ws, 40);

	// stlt@Cobjt@C̃pX𐶐
	// stlt@Cɂ́Aguidt^
	CString stlFilePath = fileName + ws + _T(".stl");
	CString objFilePath = fileName + _T(".obj");

	// xstlŕۑ
	CGLStlExporter stlExporter;
	int fileNum;
	stlExporter.Save(group, stlFilePath, fileNum);

	MGStl stl;
	CString newStlFilePath = stlFilePath;
	CString newObjFilePath = objFilePath;
	// stlŕۑۂɁAbVf[^ꍇstlt@C쐬̂ŁA
	// objt@C쐬KvB
	// o͂stl̃t@C[vB
	for (int i = 0; i < fileNum; i++){
		if (fileNum >= 2){
			// t@Cꍇ́AYt
			newStlFilePath = AddNumberToPath(stlFilePath, _T("-%02d"), i);
			newObjFilePath = AddNumberToPath(objFilePath, _T("-%02d"), i);
		}

		// stlt@Cxǂݍ
		stl.LoadFile(newStlFilePath);
		// objt@CƂĕۑ
		std::ofstream fout(newObjFilePath);
		stl.SaveObjFormatFromStl(fout);

		// o̓EChɏo͂t@C̃bZ[W\
		CString str, strMsg;
		strMsg.Format(IDS_SAVE_SUCCESS, newObjFilePath);
		str.Format(IDS_INFORMATION, strMsg);
		COUT << (TCAST)str << std::endl;

		// gpstlt@C͍폜
		DeleteFile(newStlFilePath);
	}

	return true;
}
