/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#include "stdafx.h"
#include "resource.h"
#include "IO/GLIgesExporter.h"
#include "mgIges/IgesOfstream.h"
#include "mg/Object.h"
#include "mg/Group.h"
#include "mgGL/VBO.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGLIgesExporter::CGLIgesExporter()
	 : CGLFileExporter(IDS_FILTER_IGES)
{
}

bool CGLIgesExporter::Save(const MGGroup& group){
	MGIgesOfstream fout(GetFileName());
	fout << group;
	return true;
}

/// igesf[^ۑ
bool CGLIgesExporter::Save(const std::vector<MGObject*>& objects, const CString fileName){
	MGIgesOfstream fout(fileName);
	for (size_t i = 0; i < objects.size(); i++){
		fout << *objects[i];
	}
	return true;
}
