/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file GLFileManager.h
 * @brief NX CGLFileManager ̐錾
 */
#pragma once
#include <map>

class CGLFileImporter;
class CGLFileExporter;

class CGLFileManager
{
public:
	typedef std::map<CString, CGLFileImporter*> IMap;
	typedef std::map<CString, CGLFileExporter*> OMap;

private:
	IMap m_mapi;
	OMap m_mapo;

	CGLFileManager();
	~CGLFileManager();

	CGLFileManager(const CGLFileManager&);
	CGLFileManager& operator=(const CGLFileManager&);

public:
	static CGLFileManager& GetInstance();

	CGLFileImporter* GetImporter(LPCTSTR lpszFileName) const;

	/// ۑt@CnhłIuWFNgԂB
	/// @param[in] lpszFileName gq܂ރt@CpXB
	CGLFileExporter* GetExporter(LPCTSTR lpszFileName) const;

	/// ۑ_CAÕtB^[񂩂nhłIuWFNgԂB
	/// @param[in] lpszFilter "AG Files (*.ag)" ̂悤ȕ
	CGLFileExporter* GetExporterFromFilter(LPCTSTR lpszFilter) const;

	/// nh[o^\bh
	//@{

	/// gqw肵āAC|[gnh[}l[W[ɒǉB
	/// @param[in] nIDSExt gq̃\[X ID
	/// @param[in] pHandler C|[gnh[
	void RegisterHandler(UINT nIDSExt, CGLFileImporter* pHandler);

	/// gqw肵āAC|[gnh[}l[W[ɒǉB
	/// @param[in] nIDSExt gq (e.g. "*.iges;*.igs")
	/// @param[in] pHandler C|[gnh[
	/// @pre !strExt.IsEmpty()
	void RegisterHandler(const CString& strExt, CGLFileImporter* pHandler);

	/// gqw肵āAGNX|[gnh[}l[W[ɒǉB
	/// @param[in] nIDSExt gq̃\[X ID
	/// @param[in] pHandler GNX|[gnh[
	void RegisterHandler(UINT nIDSExt, CGLFileExporter* pHandler);

	/// gqw肵āAGNX|[gnh[}l[W[ɒǉB
	/// @param[in] strExt gq  (e.g. "*.iges;*.igs")
	/// @param[in] pHandler GNX|[gnh[
	/// @pre !strExt.IsEmpty()
	void RegisterHandler(const CString& strExt, CGLFileExporter* pHandler);
	//@}

	IMap::const_iterator ibegin() const;
	IMap::const_iterator iend() const;

	OMap::const_iterator obegin() const;
	OMap::const_iterator oend() const;

	void GetAllSaveHandler(OMap& omap) const;
};
