/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#include "stdafx.h"
#include "resource.h"
#include "IO/GLFileManager.h"
#include "IO/GLFileImporter.h"
#include "IO/GLFileExporter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGLFileManager::CGLFileManager()
{
}

CGLFileManager::~CGLFileManager(){
	{
		IMap::iterator i = m_mapi.begin(), last = m_mapi.end();
		for(; i != last; ++i){
			delete i->second;
		}
	}
	{
		OMap::iterator i = m_mapo.begin(), last = m_mapo.end();
		for(; i != last; ++i){
			delete i->second;
		}
	}
}

CGLFileImporter* CGLFileManager::GetImporter(LPCTSTR lpszFileName) const
{
	// t@CpXgq܂łȂ牽ԂȂB
	CString strExt(::PathFindExtension(lpszFileName)); // hbgn܂
	if(strExt.IsEmpty()){
		return 0;
	}
	strExt.MakeLower();

	// }bv key 畔邱ƂɂȂ
	IMap::const_iterator first = m_mapi.begin(), last = m_mapi.end();
	for(; first != last; ++first){
		// "*.stp;*.step" ̂悤ȕȂ̂ŁA
		//  PathMatchSpec 邱ƂłȂB
		CString strWild(first->first);
		strWild.MakeLower();

		if(strWild.Find(strExt) != -1){
			CGLFileImporter* pHandler = first->second;
			pHandler->SetFileName(lpszFileName);
			return pHandler;
		}
	}

	return 0;
}

/// ۑt@CnhłIuWFNgԂB
/// @param[in] lpszFileName gq܂ރt@CpXB
CGLFileExporter* CGLFileManager::GetExporter(LPCTSTR lpszFileName) const
{
	// t@CpXgq܂łȂ
	// t@C_CAÕR{{bNẌʒu𗘗p邵ȂB
	CString strExt(::PathFindExtension(lpszFileName)); // hbgn܂
	if(strExt.IsEmpty()){
		return 0;
	}
	strExt.MakeLower();

	// GetImporter Ɠl̒TsB
	OMap::const_iterator first = m_mapo.begin(), last = m_mapo.end();
	for(; first != last; ++first){
		CString strWild(first->first);
		strWild.MakeLower();

		if(strWild.Find(strExt) != -1){
			CGLFileExporter* pHandler = first->second;
			pHandler->SetFileName(lpszFileName);
			return pHandler;
		}
	}

	return 0;
}

/// ۑ_CAÕtB^[񂩂nhłIuWFNgԂB
/// @param[in] lpszFilter "AG Files (*.ag)" ̂悤ȕ
CGLFileExporter* CGLFileManager::GetExporterFromFilter(LPCTSTR lpszFilter) const
{
	OMap::const_iterator first = m_mapo.begin(), last = m_mapo.end();
	for(; first != last; ++first){
		CGLFileExporter* pHandler = first->second;

		if(pHandler->GetTypeString().Compare(lpszFilter) == 0){
			return pHandler;
		}
	}
	return 0;
}

CGLFileManager& CGLFileManager::GetInstance(){
	static CGLFileManager factory;
	return factory;
}

/// gqw肵āAC|[gnh[}l[W[ɒǉB
/// @param[in] nIDSExt gq̃\[X ID
/// @param[in] pHandler C|[gnh[
void CGLFileManager::RegisterHandler(UINT nIDSExt, CGLFileImporter* pHandler)
{
	CString str;
	VERIFY(str.LoadString(nIDSExt));
	RegisterHandler(str, pHandler);
}

/// gqw肵āAC|[gnh[}l[W[ɒǉB
/// @param[in] nIDSExt gq (e.g. "*.iges;*.igs")
/// @param[in] pHandler C|[gnh[
void CGLFileManager::RegisterHandler(const CString& strExt, CGLFileImporter* pHandler)
{
	ASSERT(!strExt.IsEmpty());
	m_mapi.insert(IMap::value_type(strExt, pHandler));
	pHandler->SetExt(strExt);

	ASSERT(!pHandler->GetExt().IsEmpty());
}

/// gqw肵āAGNX|[gnh[}l[W[ɒǉB
/// @param[in] nIDSExt gq̃\[X ID
/// @param[in] pHandler GNX|[gnh[
void CGLFileManager::RegisterHandler(UINT nIDSExt, CGLFileExporter* pHandler)
{
	CString str;
	VERIFY(str.LoadString(nIDSExt));
	RegisterHandler(str, pHandler);
}

/// gqw肵āAGNX|[gnh[}l[W[ɒǉB
/// @param[in] nIDSExt gq  (e.g. "*.iges;*.igs")
/// @param[in] pHandler GNX|[gnh[
void CGLFileManager::RegisterHandler(const CString& strExt, CGLFileExporter* pHandler)
{
	ASSERT(!strExt.IsEmpty());
	m_mapo.insert(OMap::value_type(strExt, pHandler));
	pHandler->SetExt(strExt);

	ASSERT(!pHandler->GetExt().IsEmpty());
}

CGLFileManager::IMap::const_iterator CGLFileManager::ibegin() const
{
	return m_mapi.begin();
}

CGLFileManager::IMap::const_iterator CGLFileManager::iend() const
{
	return m_mapi.end();
}

CGLFileManager::OMap::const_iterator CGLFileManager::obegin() const
{
	return m_mapo.begin();
}

CGLFileManager::OMap::const_iterator CGLFileManager::oend() const
{
	return m_mapo.end();
}

void CGLFileManager::GetAllSaveHandler(OMap& omap) const{
	omap = m_mapo;
}
