/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLSimpleInputDlg.cpp : t@C

#include "stdafx.h"
#include "fugen.h"
#include "GLSimpleInputDlg.h"

// CGLSimpleInputDlg _CAO

CGLSimpleInputDlg::CGLSimpleInputDlg(
	const CString& strTitle,
	const CString& strPrompt)
	 : CDialog(CGLSimpleInputDlg::IDD, 0),
	   m_strTitle(strTitle),
	   m_strPrompt(strPrompt)
{
}

void CGLSimpleInputDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
}

BOOL CGLSimpleInputDlg::OnInitDialog(){
	CDialog::OnInitDialog();

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	if(!m_strTitle.IsEmpty()){
		SetWindowText(m_strTitle);
	}

	if(!m_strPrompt.IsEmpty()){
		SetDlgItemText(IDC_STATIC_PROMPT, m_strPrompt);
	}

	if(!m_strUserInput.IsEmpty()){
		SetDlgItemText(IDC_LINE_EDIT, m_strUserInput);
		SendDlgItemMessage(IDC_LINE_EDIT, EM_SETSEL, 0, -1);
	}

	return TRUE;
}

void CGLSimpleInputDlg::OnOK(){
	CDialog::OnOK();
	GetDlgItemText(IDC_LINE_EDIT, m_strUserInput);
}

BEGIN_MESSAGE_MAP(CGLSimpleInputDlg, CDialog)
END_MESSAGE_MAP()

CString CGLSimpleInputDlg::GetText() const{
	return m_strUserInput;
}

void CGLSimpleInputDlg::SetText(const CString& str){
	m_strUserInput = str;
}
