/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#include "stdafx.h"
#include "fugen.h"
#include "GLNamedViewDlg.h"
#include "ViewCmd/NamedViewTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGLNamedViewDlg::CGLNamedViewDlg(MGNamedViewTool* tool)
: CGLNamedTargetDlg(tool){
}

BEGIN_MESSAGE_MAP(CGLNamedViewDlg, CGLNamedTargetDlg)
END_MESSAGE_MAP()

CString CGLNamedViewDlg::GetInputDlgTitle() const{
	CString str;
	str.LoadString(IDS_INPUT_DLG_TITLE_NAMED_VIEW);
	return str;
}

CString CGLNamedViewDlg::GetInputDlgLabelSave() const{
	CString str;
	str.LoadString(IDS_INPUT_DLG_LABEL_NAMED_VIEW_SAVE);
	return str;
}

CString CGLNamedViewDlg::GetInputDlgLabelRename() const{
	CString str;
	str.LoadString(IDS_INPUT_DLG_LABEL_NAMED_VIEW_RENAME);
	return str;
}

void CGLNamedViewDlg::LoadBitmap(CBitmap& bmp) const{
	bmp.LoadBitmap(IDB_NAMED_VIEW);
}

MGNamedViewTool* CGLNamedViewDlg::getNamedViewTool(){
	return static_cast<MGNamedViewTool*>(getCmdTool());
}

INamedTargetTool * CGLNamedViewDlg::getNamedTargetTool(){
	return static_cast<INamedTargetTool*>(getNamedViewTool());
}