/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#include "stdafx.h"
#include "fugen.h"
#include "Common/CommandBase.h"
#include "GLNamedTargetDlg.h"
#include "ViewCmd/INamedTargetTool.h"
#include "GLSimpleInputDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGLNamedTargetDlg::CGLNamedTargetDlg(MGCommandBase* tool)
: mgModelessDialogue(tool){
}

void CGLNamedTargetDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLNamedTargetDlg)
	DDX_Control(pDX, IDC_LIST_NAMED, m_list);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGLNamedTargetDlg, mgModelessDialogue)
	//{{AFX_MSG_MAP(CGLNamedTargetDlg)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_NAMED, OnItemChanged)
	ON_BN_CLICKED(IDC_BUTTON_SAVE, OnBtnSave)
	ON_BN_CLICKED(IDC_BUTTON_RESTORE, OnBtnRestore)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnBtnDelete)
	ON_BN_CLICKED(IDC_BUTTON_RENAME, OnBtnRename)
	//}}AFX_MSG_MAP	
END_MESSAGE_MAP()

BOOL CGLNamedTargetDlg::OnInitDialog(){
	if(!mgModelessDialogue::OnInitDialog()){
		return FALSE;
	}

	// Create the full-color image list
	// cx, cy = your icon width & height
	// You could also use ILC_COLOR24 rather than ILC_COLOR32
	m_img.Create(32, 32, ILC_MASK | ILC_COLOR32, 0, 0);

	CBitmap bmp;
	LoadBitmap(bmp);

	// Set up your transparent color as appropriate
	COLORREF rgbTransparentColor = RGB(0xFF, 0xFF, 0xFF);

	// Add the bitmap into the image list
	m_img.Add(&bmp, rgbTransparentColor);

	m_list.SetExtendedStyle(m_list.GetExtendedStyle() | LVS_EX_FULLROWSELECT);
	m_list.SetImageList(&m_img, LVSIL_SMALL);

	CRect rc;
	m_list.GetClientRect(rc);
	m_list.InsertColumn(0, _T(""), LVCFMT_LEFT, rc.Width());

	INamedTargetTool* tool = getNamedTargetTool();
	std::vector<CString> names;
	tool->List(names);
	int nTarg = (int)names.size();
	for(int i = 0; i < nTarg; ++i){
		m_list.InsertItem(i, names[i], 0);
	}

	UpdateControls();
	return TRUE;
}

int CGLNamedTargetDlg::GetCurItem() const{
	int nItem = -1;
	POSITION pos = m_list.GetFirstSelectedItemPosition();
	if(pos){
		nItem = m_list.GetNextSelectedItem(pos);
	}
	return nItem;
}

void CGLNamedTargetDlg::OnItemChanged(NMHDR* pNMHDR, LRESULT* pResult){
	//NMLISTVIEW* pListView = reinterpret_cast<NMLISTVIEW*>(pNMHDR);
	UpdateControls();
	*pResult = 0;
}

void CGLNamedTargetDlg::OnBtnSave(){

	int nItem = GetCurItem();
	if(nItem != -1){
		//uXV܂vvvgB
		if(IDYES != AfxMessageBox(IDS_QUESTION_NAMED_TARGET_MODIFY, MB_YESNO | MB_ICONQUESTION)){
			nItem = -1;
		}
	}

	INamedTargetTool* tool = getNamedTargetTool();
	if(nItem == -1){
		// IȂԂł̕ۑBȂ킿VKۑB
		// O̓_CAOB
		CGLSimpleInputDlg dlg(GetInputDlgTitle(), GetInputDlgLabelSave());
		if(dlg.DoModal() != IDOK){
			return;
		}
		CString strNewName = dlg.GetText();

		// ݂̃r[ݒۑB
		if(!strNewName.IsEmpty()){
			// ̐ݒƖOdĂ邩eXgB
			LVFINDINFO info;
			info.flags = LVFI_STRING;
			info.psz = strNewName;
			if(m_list.FindItem(&info) != -1){
				// ɑ݂܂BXV܂H
				if(IDYES != AfxMessageBox(IDS_QUESTION_NAMED_TARGET_DUP_NAME, MB_YESNO | MB_ICONQUESTION)){
					return;
				}
			}
			tool->Save(strNewName);
			m_list.InsertItem(m_list.GetItemCount(), strNewName);
		}
	}else{
		// XV[h
		CString strName = m_list.GetItemText(nItem, 0);
		tool->Save(strName);
		m_list.SetItemText(nItem, 0, strName);
	}
}

void CGLNamedTargetDlg::OnBtnRestore(){
	int nItem = GetCurItem();
	if(nItem != -1){
		CString strName = m_list.GetItemText(nItem, 0);
		if(!strName.IsEmpty()){
			INamedTargetTool* tool = getNamedTargetTool();
			tool->Restore(strName);
		}
	}
}

void CGLNamedTargetDlg::OnBtnDelete(){
	int nItem = GetCurItem();
	if(nItem != -1){
		CString strName = m_list.GetItemText(nItem, 0);
		if(!strName.IsEmpty()){
			INamedTargetTool* tool = getNamedTargetTool();
			tool->Delete(strName);
			m_list.DeleteItem(nItem);
		}
	}
}

void CGLNamedTargetDlg::OnBtnRename(){
	int nItem = GetCurItem();
	if(nItem == -1){
		return;
	}

	CString strOldName = m_list.GetItemText(nItem, 0);

	// O̓_CAOB

	CGLSimpleInputDlg dlg(GetInputDlgTitle(), GetInputDlgLabelRename());
	dlg.SetText(strOldName);
	if(dlg.DoModal() != IDOK){
		return;
	}
	CString strNewName = dlg.GetText();

	if(!strNewName.IsEmpty()){
		// ̐ݒƖOdĂ邩eXgB
		LVFINDINFO info;
		info.flags = LVFI_STRING;
		info.psz = strNewName;

		INamedTargetTool* tool = getNamedTargetTool();
		if(m_list.FindItem(&info) != -1){
			if(IDYES != AfxMessageBox(IDS_QUESTION_NAMED_TARGET_DUP_NAME, MB_YESNO | MB_ICONQUESTION)){
				return;
			}
			tool->Save(strNewName);
		}else{
			// Go
			tool->Rename(strOldName, strNewName);
			m_list.SetItemText(nItem, 0, strNewName);
		}
	}
}

void CGLNamedTargetDlg::UpdateControls(){
	BOOL bItemSel = m_list.GetSelectedCount() > 0;

	GetDlgItem(IDC_BUTTON_SAVE)->EnableWindow(); // ɗLB
	GetDlgItem(IDC_BUTTON_RESTORE)->EnableWindow(bItemSel);
	GetDlgItem(IDC_BUTTON_DELETE)->EnableWindow(bItemSel);
	GetDlgItem(IDC_BUTTON_RENAME)->EnableWindow(bItemSel);
}
