/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLMeshPropPane.cpp : Cve[V t@C

#include "stdafx.h"
#include "fugen.h"
#include "fugenDoc.h"
#include "GLMeshPropPane.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLMeshPropPane _CAO

CGLMeshPropPane::CGLMeshPropPane(fugenDoc* pDoc)
	:CGLPropPane(pDoc){
}

void CGLMeshPropPane::DoDataExchange(CDataExchange* pDX){
	CGLPropPane::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CGLMeshPropPane)
	DDX_Check(pDX, IDC_CHECK_ISOCURVE, m_bShowIsoCurve);

	DDX_Control(pDX, IDC_SPIN_ISOCURVE_DENSITY, m_spnIsoCurve);
	DDX_Text(pDX, IDC_EDIT_ISOCURVE_DENSITY, m_nIsoCurve);
	DDV_MinMaxInt(pDX, m_nIsoCurve, m_nIsoCurveMin, m_nIsoCurveMax);

	DDX_Text(pDX, IDC_EDIT_MESH_CURVE, m_dCurve);
	DDV_PositiveDouble(pDX, m_dCurve);
	DDX_Text(pDX, IDC_EDIT_MESH_SURF, m_dSurf);
	DDV_PositiveDouble(pDX, m_dSurf);
	DDX_Text(pDX, IDC_EDIT_MESH_MAX_EDGE, m_dEdgeLenMax);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGLMeshPropPane, CGLPropPane)
	//{{AFX_MSG_MAP(CGLMeshPropPane)
	ON_BN_CLICKED(IDC_CHECK_ISOCURVE, OnClickedShowIsoCurve)
	ON_BN_CLICKED(IDC_BUTTON_PROP_MESH_DEFAULT, OnButtonPropMeshDefault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CGLMeshPropPane::OnClickedShowIsoCurve()
{
	if(UpdateData()){
		return;
	}
}

void CGLMeshPropPane::OnButtonPropMeshDefault(){

	OnReset();
	UpdateData(FALSE);
	Invalidate();
}

void CGLMeshPropPane::LoadUserProf(){
	//UserPreference擾
	UserPreference& pref = UserPreference::getInstance();

	pref.GetIntValue(upv_IsoCurve_Density, m_nIsoCurve, m_nIsoCurveMin, m_nIsoCurveMax);
	m_spnIsoCurve.SetRange32(m_nIsoCurveMin, m_nIsoCurveMax);

	m_nIsoCurve = pref.GetIntValue(upv_IsoCurve_Density);
	m_bShowIsoCurve = pref.GetBoolValue(upv_IsoCurve_Show);
	m_dCurve = pref.GetDoubleValue(upv_Tess_CurveTol);
	m_dSurf = pref.GetDoubleValue(upv_Tess_SurfTol);
	m_dEdgeLenMax = pref.GetDoubleValue(upv_Tess_MaxEdgeLen);

	UpdateData(FALSE);
}

BOOL CGLMeshPropPane::UpdateUserProf(){
	if(UpdateData()){
		// VXeݒXVĂB
		UserPreference& pref = UserPreference::getInstance();

		pref.SetDoubleValue(upv_Tess_CurveTol, m_dCurve);
		pref.SetDoubleValue(upv_Tess_SurfTol, m_dSurf);
		pref.SetDoubleValue(upv_Tess_MaxEdgeLen, m_dEdgeLenMax);

		pref.SetBoolValue(upv_IsoCurve_Show, m_bShowIsoCurve==TRUE);
		pref.SetIntValue(upv_IsoCurve_Density, m_nIsoCurve);

		return TRUE;
	}
	return FALSE;
}

void CGLMeshPropPane::ResetToDefaultUserProf(){
	//UserPreference擾
	UserPreference& pref = UserPreference::getInstance();

	pref.GetIntValue(upv_IsoCurve_Density, m_nIsoCurve, m_nIsoCurveMin, m_nIsoCurveMax);
	m_spnIsoCurve.SetRange32(m_nIsoCurveMin, m_nIsoCurveMax);

	m_nIsoCurve = pref.GetIntValue(upv_IsoCurve_Density, UserPreference::DefaultValue);
	m_bShowIsoCurve = pref.GetBoolValue(upv_IsoCurve_Show, UserPreference::DefaultValue);
	m_dCurve = pref.GetDoubleValue(upv_Tess_CurveTol, UserPreference::DefaultValue);
	m_dSurf = pref.GetDoubleValue(upv_Tess_SurfTol, UserPreference::DefaultValue);
	m_dEdgeLenMax = pref.GetDoubleValue(upv_Tess_MaxEdgeLen, UserPreference::DefaultValue);

	UpdateData(FALSE);
}

void CGLMeshPropPane::LoadDocContext(){
	ASSERT_VALID(m_pTargetDoc);
	//DocumentContext擾
	const MGContext* ct = m_pTargetDoc->context();
	ASSERT(ct);

	// Min.Max DDV value setting.
	UserPreference& pref = UserPreference::getInstance();
	pref.GetIntValue(upv_IsoCurve_Density, m_nIsoCurve, m_nIsoCurveMin, m_nIsoCurveMax);
	m_spnIsoCurve.SetRange32(m_nIsoCurveMin, m_nIsoCurveMax);

	const mgTLInputParam& tp = ct->tessellate_param();
	m_dCurve = tp.crvTol();
	m_dSurf = tp.surfTol();
	m_dEdgeLenMax = tp.max_edge_len();

	m_nIsoCurve = ct->line_density();
	m_bShowIsoCurve = m_nIsoCurve != 0;

	UpdateData(FALSE);
}

BOOL CGLMeshPropPane::UpdateDocContext(){
	ASSERT_VALID(m_pTargetDoc);
	MGContext* ct = m_pTargetDoc->context();
	ASSERT(ct);

	if(UpdateData()){
		mgTLInputParam& tp = ct->tessellate_param();

		tp.set_crvTol(m_dCurve);
		tp.set_surfTol(m_dSurf);
		tp.set_max_edge_len(m_dEdgeLenMax);

		ct->set_line_density(m_bShowIsoCurve ? m_nIsoCurve : 0);

		m_pTargetDoc->get_main_group().setDirty(true);
		m_pTargetDoc->apply_view_context_colors();
		return TRUE;
	}
	return FALSE;
}

void CGLMeshPropPane::ResetToDefaultDocContext(){
	//UserPreference擾
	UserPreference& pref = UserPreference::getInstance();

	pref.GetIntValue(upv_IsoCurve_Density, m_nIsoCurve, m_nIsoCurveMin, m_nIsoCurveMax);
	m_nIsoCurve = pref.GetIntValue(upv_IsoCurve_Density);
	m_bShowIsoCurve = pref.GetBoolValue(upv_IsoCurve_Show);
	m_dCurve = pref.GetDoubleValue(upv_Tess_CurveTol);
	m_dSurf = pref.GetDoubleValue(upv_Tess_SurfTol);
	m_dEdgeLenMax = pref.GetDoubleValue(upv_Tess_MaxEdgeLen);

	UpdateData(FALSE);
}

