/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#pragma once
#include "resource.h"
#include "mg/MGStl.h"

// CGLMeshInfoDlg _CAO

class CGLMeshInfoDlg : public CDialog
{
	DECLARE_DYNAMIC(CGLMeshInfoDlg)

	// }`̃{bNXgX, Y, ZW̍őAŏlێ
	// GfBbg{bNX̃Rg[ϐ
	double m_minX, m_maxX;
	double m_minY, m_maxY;
	double m_minZ, m_maxZ;

	// Op`̐A_i[
	// GfBbg{bNX̃Rg[ϐ
	size_t m_nTriangle;
	size_t m_nVert;

public:
	CGLMeshInfoDlg(CWnd* pParent = NULL);   // WRXgN^
	virtual ~CGLMeshInfoDlg();

// _CAO f[^
	enum { IDD = IDD_MESH_INFO };

	// _CAO[size information]̓ɂ
	// GfBbg{bNXɐ}`̃{bNXg
	// X, Y, ZW̍őlAŏlݒ肷
	// O:no throw
	void SetBoxEdit(const MGBox& box);

	// GfBbg{bNXɐݒ肳ĂOp`Ԃ
	size_t GetTriangleCount()const{return m_nTriangle;}

	// GfBbg{bNXɐݒ肳Ă钸_Ԃ
	size_t GetVertexCount()const{return m_nVert;}

	// Op`i[GfBbg{bNXɒlݒ肷
	void SetTriangleCount(size_t nTriangle){m_nTriangle=nTriangle;}

	// _i[GfBbg{bNXɒlݒ肷
	void SetVertexCount(size_t nVert){m_nVert=nVert;}

	// Op`̐A_\GfBbg{bNXo
	// Op`A_ݒ肷
	void SetTriangleEdit(const std::vector<UniqueStl>& stl);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()

private:
	// {bNXgwGfBbg{bNXɕ\Ă
	// 8ȍ~\Ȃ悤ɍ폜
	void CutEditBoxDigit();

	// w肵GfBbg{bNX̕
	// w肵͈͂폜AJ[\GfBbg{bNX̐擪ɖ߂
	void EraseEditString(
		int start, // 폜镶̊Jnʒu
		int end,   // 폜镶̏Iʒu
		int ID	   // Ώۂ̃GfBbg{bNX̃\[XID
		);
};
