/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLMeshInfoDlg.cpp : t@C

#include "stdafx.h"
#include "fugen.h"
#include "GLMeshInfoDlg.h"

#include "mg/MGStl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// CGLMeshInfoDlg _CAO

IMPLEMENT_DYNAMIC(CGLMeshInfoDlg, CDialog)
CGLMeshInfoDlg::CGLMeshInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGLMeshInfoDlg::IDD, pParent),
	  m_maxX(0.),
	  m_maxY(0.),
	  m_maxZ(0.),
	  m_minX(0.),
	  m_minY(0.),
	  m_minZ(0.),
	  m_nTriangle(0),
	  m_nVert(0)
{
}

CGLMeshInfoDlg::~CGLMeshInfoDlg()
{
}

void CGLMeshInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

	// }`̍W̍őlAŏl\pGfBbg{bNX
	DDX_Text(pDX, IDC_MAX_X, m_maxX);
	DDX_Text(pDX, IDC_MAX_Y, m_maxY);
	DDX_Text(pDX, IDC_MAX_Z, m_maxZ);
	DDX_Text(pDX, IDC_MIN_X, m_minX);
	DDX_Text(pDX, IDC_MIN_Y, m_minY);
	DDX_Text(pDX, IDC_MIN_Z, m_minZ);
	// Op`A_\pGfBbg{bNX
	DDX_Text(pDX, IDC_TRIANGLE, m_nTriangle);
	DDX_Text(pDX, IDC_VERTEX, m_nVert);

	/*
	if(!pDX->m_bSaveAndValidate){
		CutEditBoxDigit();
	}*/
}

BEGIN_MESSAGE_MAP(CGLMeshInfoDlg, CDialog)
END_MESSAGE_MAP()

BOOL CGLMeshInfoDlg::OnInitDialog()
{
	if(!CDialog::OnInitDialog()){
		return FALSE;
	}

	// ʂȏKvȏꍇɂɏƂɂȂ

	return TRUE;
}

// _CAO[size information]̓ɂ
// GfBbg{bNXɐ}`̃{bNXg
// X, Y, ZW̍őlAŏlݒ肷
// O:no throw
void CGLMeshInfoDlg::SetBoxEdit(const MGBox& box)
{
	// {bNXg̊eW̍őAŏlo
	const MGPosition& minPos = box.low();
	// Rg[ϐɐݒ
	m_minX = MGCL::decimalAlign(minPos[0]);
	m_minY = MGCL::decimalAlign(minPos[1]);
	m_minZ = MGCL::decimalAlign(minPos[2]);

	const MGPosition& maxPos = box.high();
	m_maxX = MGCL::decimalAlign(maxPos[0]);
	m_maxY = MGCL::decimalAlign(maxPos[1]);
	m_maxZ = MGCL::decimalAlign(maxPos[2]);
}

// {bNXgwGfBbg{bNXɕ\Ă
// 8ȍ~\Ȃ悤ɂ
void CGLMeshInfoDlg::CutEditBoxDigit()
{
	// GfBbg{bNXɕ\Ă镶
	// JnʒuIʒu܂ō폜
	EraseEditString(8, -1, IDC_MIN_X);
	EraseEditString(8, -1, IDC_MIN_Y);
	EraseEditString(8, -1, IDC_MIN_Z);
	EraseEditString(8, -1, IDC_MAX_X);
	EraseEditString(8, -1, IDC_MAX_Y);
	EraseEditString(8, -1, IDC_MAX_Z);
}

// w肵GfBbg{bNX̕
// w肵͈͂폜AJ[\GfBbg{bNX̐擪ɖ߂
void CGLMeshInfoDlg::EraseEditString(
	int start, // 폜镶̊Jnʒu
	int end,   // 폜镶̏Iʒu
	int ID	   // Ώۂ̃GfBbg{bNX̃\[XID
	)
{
	CEdit* pEdit = (CEdit*)GetDlgItem(ID);
	// w肵͈͂̕I
	pEdit->SetSel(start,end);
	// I폜
	pEdit->Clear();
	// J[\̈ʒuGfBbg{bNX̐擪ɖ߂
	pEdit->SetSel(0,0);
}

// Op`̐A_\GfBbg{bNXo
// Op`A_ݒ肷
void CGLMeshInfoDlg::SetTriangleEdit(const std::vector<UniqueStl>& stl){
	ASSERT(!stl.empty());

	size_t nStl = stl.size();

	const MGStl& stl0 = *stl.front();
	size_t TriangleCount = stl0.normals().size();
	size_t VertexCount = stl0.positions().size();
	MGBox TempBox = stl0.box();
	for(size_t i=1;i<nStl;i++){
		const MGStl& stli = *stl[i];

		TempBox |= stli.box();
		TriangleCount += stli.normals().size();
		VertexCount += stli.positions().size();
	}
	// DDX t̃o[f[^ɒlZbg
	SetBoxEdit(TempBox);
	SetTriangleCount(TriangleCount);
	SetVertexCount(VertexCount);

	// _CAO̕\XV
	UpdateData(FALSE);
}
