/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#pragma once

#include "GLMeshTessDlg.h"
#include "GLMeshDisplayDlg.h"
#include "GLMeshSaveDlg.h"
#include "GLMeshInfoDlg.h"

class MGMeshTool;

// CGLMeshFromObjDlg _CAO

class CGLMeshFromObjDlg : public CDialog
{
	DECLARE_DYNAMIC(CGLMeshFromObjDlg)

	CTabCtrl m_tab;

	CGLMeshTessDlg m_tess;
	CGLMeshDisplayDlg m_disp;
	CGLMeshSaveDlg m_save;
	CGLMeshInfoDlg m_info;

	MGMeshTool* m_pCmd;

public:
	CGLMeshFromObjDlg(CWnd* pParent = NULL);   // WRXgN^
	virtual ~CGLMeshFromObjDlg();

	void SetCmd(MGMeshTool* pCmd);

// _CAO f[^
	enum { IDD = IDD_MESH_FROM_OBJECT };

	/// q_CAOւ̒ڃANZX
	//@{
	CGLMeshTessDlg& GetTess(){ return m_tess; }
	CGLMeshDisplayDlg& GetDisplay(){ return m_disp; }
	CGLMeshSaveDlg& GetSave(){ return m_save; }
	CGLMeshInfoDlg& GetInfo(){ return m_info; }
	//@}

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	virtual BOOL OnInitDialog();
	virtual void PostNcDestroy();

	virtual void OnOK();
	virtual void OnCancel();

	afx_msg void OnTcnSelchangeMeshCreateTab(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg LRESULT OnFacetParamChanged(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDisplayStyleChanged(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnMeshSave(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
};
