/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// GLMeshFromObjDlg.cpp : t@C

#include "stdafx.h"
#include "fugen.h"
#include "GLMeshFromObjDlg.h"
#include "fugenDoc.h"
#include "MeshCmd/MeshTool.h"
#include "GLWndMsg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// CGLMeshFromObjDlg _CAO

IMPLEMENT_DYNAMIC(CGLMeshFromObjDlg, CDialog)

CGLMeshFromObjDlg::CGLMeshFromObjDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGLMeshFromObjDlg::IDD, pParent)
{
}

CGLMeshFromObjDlg::~CGLMeshFromObjDlg()
{
}

BEGIN_MESSAGE_MAP(CGLMeshFromObjDlg, CDialog)
	ON_NOTIFY(TCN_SELCHANGE, IDC_MESH_FROM_OBJECT_TAB, OnTcnSelchangeMeshCreateTab)

	ON_MESSAGE(WM_FUGEN_MESH_PARAM_CHANGED, OnFacetParamChanged)
	ON_MESSAGE(WM_FUGEN_MESH_DISPLAY_STYLE_CHANGED, OnDisplayStyleChanged)
	ON_MESSAGE(WM_FUGEN_MESH_SAVE, OnMeshSave)
END_MESSAGE_MAP()

void CGLMeshFromObjDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MESH_FROM_OBJECT_TAB, m_tab);
}

BOOL CGLMeshFromObjDlg::OnInitDialog()
{
	VERIFY(CDialog::OnInitDialog());

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	// ^uɏ悹uy[Wv̍쐬

	VERIFY(m_tess.Create(CGLMeshTessDlg::IDD, this)); // tab[0]: p[^
	VERIFY(m_disp.Create(CGLMeshDisplayDlg::IDD, this)); // tab[1]: `
	VERIFY(m_save.Create(CGLMeshSaveDlg::IDD, this)); // tab[2]: ۑ
	VERIFY(m_info.Create(CGLMeshInfoDlg::IDD, this)); // tab[3]: 

	// ey[Ẅʒu
	CRect rc;
	m_tab.GetClientRect(rc);
	m_tab.AdjustRect(FALSE, rc);

	CRect rcWin;
	m_tab.GetWindowRect(rcWin);
	GetParent()->ScreenToClient(rcWin);
	rc.OffsetRect(rcWin.left, rcWin.top);

	m_tess.SetWindowPos(0, rc.left, rc.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	m_disp.SetWindowPos(0, rc.left, rc.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	m_save.SetWindowPos(0, rc.left, rc.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	m_info.SetWindowPos(0, rc.left, rc.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);

	// ^uǉ
	CString strTab;
	strTab.LoadString(IDS_MESH_TAB_PARAM);
	m_tab.InsertItem(0, strTab);
	strTab.LoadString(IDS_MESH_TAB_DISPLAY);
	m_tab.InsertItem(1, strTab);
	strTab.LoadString(IDS_MESH_TAB_SAVE);
	m_tab.InsertItem(2, strTab);
	strTab.LoadString(IDS_MESH_TAB_INFO);
	m_tab.InsertItem(3, strTab);

	// ŏ̃^uANeBuɂ
	m_tab.SetCurSel(0);
	m_tess.ShowWindow(SW_SHOW);

	UpdateData(FALSE);
	return TRUE;
}

void CGLMeshFromObjDlg::PostNcDestroy()
{
	// [hX_CAO
	delete this;
}

void CGLMeshFromObjDlg::SetCmd(MGMeshTool* pCmd)
{
	m_pCmd = pCmd;
}

// CGLMeshFromObjDlg bZ[W nh

void CGLMeshFromObjDlg::OnTcnSelchangeMeshCreateTab(NMHDR* pNMHDR, LRESULT *pResult)
{
	ASSERT(pResult);

	const int nSel = m_tab.GetCurSel();

	m_tess.ShowWindow(nSel == 0 ? SW_SHOW : SW_HIDE);
	m_disp.ShowWindow(nSel == 1 ? SW_SHOW : SW_HIDE);
	m_save.ShowWindow(nSel == 2 ? SW_SHOW : SW_HIDE);
	m_info.ShowWindow(nSel == 3 ? SW_SHOW : SW_HIDE);

	*pResult = 0;
}

LRESULT CGLMeshFromObjDlg::OnFacetParamChanged(WPARAM wParam, LPARAM lParam)
{
	if(!m_pCmd){
		return 0;
	}

	// R}hɍăt@Zbg𑣂
	m_pCmd->SetModifiedFlag(true);
	m_pCmd->UpdateUI();

	return 0;
}

LRESULT CGLMeshFromObjDlg::OnDisplayStyleChanged(WPARAM wParam, LPARAM lParam)
{
	if(!m_pCmd){
		return 0;
	}

	// ύXtOɐGȂ
	//m_pCmd->SetModifiedFlag();
	m_pCmd->UpdateUI();

	return 0;
}

LRESULT CGLMeshFromObjDlg::OnMeshSave(WPARAM wParam, LPARAM lParam)
{
	if(!m_pCmd){
		return 0;
	}

	// Cxg]
	m_pCmd->OnMeshSave();
	return 0;
}

void CGLMeshFromObjDlg::OnOK()
{
	if(!UpdateData()){
		return;
	}
	ShowWindow(SW_HIDE);

	if(m_pCmd){
		// R}hʏIƂB
		MGCommandBase* pCmd = m_pCmd;
		m_pCmd->DetachDialog();
		m_pCmd = 0;
		pCmd->document()->normalEnd_command_tool(pCmd, 1);
	}

	// [hX_CAO
	DestroyWindow();
}

void CGLMeshFromObjDlg::OnCancel()
{
	ShowWindow(SW_HIDE);

	if(m_pCmd){
		// R}hLZIƂB
		MGCommandBase* pCmd = m_pCmd;
		m_pCmd->DetachDialog();
		m_pCmd = 0;
		pCmd->document()->cancel_command_tool(pCmd, 1);
	}
	// [hX_CAO
	DestroyWindow();
}