/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLMeshDisplayDlg.cpp : t@C

#include "stdafx.h"
#include "fugen.h"
#include "GLMeshDisplayDlg.h"
#include "GLWndMsg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// CGLMeshDisplayDlg _CAO

IMPLEMENT_DYNAMIC(CGLMeshDisplayDlg, CDialog)

CGLMeshDisplayDlg::CGLMeshDisplayDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGLMeshDisplayDlg::IDD, pParent)
{
}

CGLMeshDisplayDlg::~CGLMeshDisplayDlg()
{
}

void CGLMeshDisplayDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MESH_DISPLAY_COMBO, m_combo);
}

BEGIN_MESSAGE_MAP(CGLMeshDisplayDlg, CDialog)
	ON_CBN_SELCHANGE(IDC_MESH_DISPLAY_COMBO, OnCbnSelchangeMeshDisplayCombo)
END_MESSAGE_MAP()

BOOL CGLMeshDisplayDlg::OnInitDialog()
{
	if(!CDialog::OnInitDialog()){
		return FALSE;
	}

	// hbv_EXg̏
	CString strItem;
	strItem.LoadString(IDS_MESH_DISPLAY_WIRE);
	m_combo.InsertString(-1, strItem);
	strItem.LoadString(IDS_MESH_DISPLAY_SHADE);
	m_combo.InsertString(-1, strItem);
	strItem.LoadString(IDS_MESH_DISPLAY_MIXED);
	m_combo.InsertString(-1, strItem);

	// hbv_EXg̏I
	m_combo.SetCurSel(0);

	UpdateData(FALSE);
	return TRUE;
}

MGCL::VIEWMODE CGLMeshDisplayDlg::GetViewMode() const
{
	ASSERT_VALID(&m_combo);
	return static_cast<MGCL::VIEWMODE>(m_combo.GetCurSel()+1);
}

// CGLMeshDisplayDlg bZ[W nh

void CGLMeshDisplayDlg::OnCbnSelchangeMeshDisplayCombo()
{
	if(!UpdateData()){
		return;
	}

	// e_CAOoRŕ`X^CύXR}hɒm点B
	GetParent()->SendMessage(WM_FUGEN_MESH_DISPLAY_STYLE_CHANGED);
}

