/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLGeneralPropPane.cpp : t@C

#include "stdafx.h"
#include "fugen.h"
#include "fugenDoc.h"
#include "GLGeneralPropPane.h"
#include "Misc/UserPreference.h"
#include "Undo/IActionManager.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// CGLGeneralPropPane _CAO

//CGLGeneralPropPane::CGLGeneralPropPane(CGLPropDialog* propPanel)
//:CGLPropPane(propPanel)//,
////	m_nUndoCount(1000), m_nUndoMem(4096), m_bShowIsoCurve(TRUE), m_nIsoCurve(1)
//, m_nSelLang(0)
//{
//}

CGLGeneralPropPane::CGLGeneralPropPane(fugenDoc* pDoc)
	:CGLPropPane(pDoc)
{
}

void CGLGeneralPropPane::DoDataExchange(CDataExchange* pDX)
{
	CGLPropPane::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_SPIN_LIMIT_UNDO, m_spnUndoCount);
	DDX_Text(pDX, IDC_EDIT_LIMIT_UNDO, m_nUndoCount);
	DDV_MinMaxInt(pDX, m_nUndoCount, m_nUndoCountMin, m_nUndoCountMax);

	//DDX_Control(pDX, IDC_SPIN_MAX_MEMORY, m_spnUndoMem);
	//DDX_Text(pDX, IDC_EDIT_MAX_MEMORY, m_nUndoMem);
	//DDV_MinMaxInt(pDX, m_nUndoMem, m_nUndoMemMin, m_nUndoMemMax);

	DDX_CBIndex(pDX, IDC_COMBO_LANGUAGE, m_nSelLang);
}


BEGIN_MESSAGE_MAP(CGLGeneralPropPane, CGLPropPane)
	ON_BN_CLICKED(IDC_BUTTON_PROP_GENERAL_DEFAULT, OnButtonPropGeneralDefault)
END_MESSAGE_MAP()

// CGLGeneralPropPane bZ[W nh

void CGLGeneralPropPane::OnButtonPropGeneralDefault(){
	UserPreference& pref = UserPreference::getInstance();

	m_nUndoCount = pref.GetIntValue(upv_Undo_Size, UserPreference::DefaultValue);
	//m_nUndoMem = pref.GetIntValue(upv_Undo_Memory, UserPreference::DefaultValue);

	UpdateData(FALSE);
	Invalidate();
}

void CGLGeneralPropPane::LoadUserProf(){
	UserPreference& pref = UserPreference::getInstance();

	pref.GetIntValue(upv_Undo_Size, m_nUndoCount, m_nUndoCountMin, m_nUndoCountMax);
	pref.GetIntValue(upv_Undo_Memory, m_nUndoMem, m_nUndoMemMin, m_nUndoMemMax);
	m_nSelLang = pref.GetIntValue(upv_Screen_Lang);

	// Min/Max p[^ݒ
	m_spnUndoCount.SetRange32(m_nUndoCountMin, m_nUndoCountMax);
	//m_spnUndoMem.SetRange32(m_nUndoMemMin, m_nUndoMemMax);

	UpdateData(FALSE);
}

BOOL CGLGeneralPropPane::UpdateUserProf(){
	if(UpdateData()){
		UserPreference& pref = UserPreference::getInstance();

		pref.SetIntValue(upv_Undo_Size, m_nUndoCount);
		pref.SetIntValue(upv_Undo_Memory, m_nUndoMem);

		pref.SetIntValue(upv_Screen_Lang, m_nSelLang);

		// JgȃhLg΁AύXĂB
		if(m_pTargetDoc){
			UpdateDocContext();
		}

		return TRUE;
	}
	return FALSE;
}

void CGLGeneralPropPane::ResetToDefaultUserProf(){
	UserPreference& pref = UserPreference::getInstance();

	pref.GetIntValue(upv_Undo_Size, m_nUndoCount, m_nUndoCountMin, m_nUndoCountMax);
	pref.GetIntValue(upv_Undo_Memory, m_nUndoMem, m_nUndoMemMin, m_nUndoMemMax);

	// Min/Max p[^ݒ
	m_spnUndoCount.SetRange32(m_nUndoCountMin, m_nUndoCountMax);
	//m_spnUndoMem.SetRange32(m_nUndoMemMin, m_nUndoMemMax);
	m_nUndoCount = pref.GetIntValue(upv_Undo_Size, UserPreference::DefaultValue);
	m_nSelLang = pref.GetIntValue(upv_Screen_Lang, UserPreference::DefaultValue);

	UpdateData(FALSE);
}

void CGLGeneralPropPane::LoadDocContext(){
	ASSERT_VALID(m_pTargetDoc);

	ASSERT(FALSE);
}

BOOL CGLGeneralPropPane::UpdateDocContext(){

	ASSERT_VALID(m_pTargetDoc);

	if(UpdateData()){
		m_pTargetDoc->GetActionManager()->SetStackCapacity(m_nUndoCount);
		return TRUE;
	}
	return FALSE;
}

void CGLGeneralPropPane::ResetToDefaultDocContext(){
	ASSERT_VALID(m_pTargetDoc);

	ASSERT(FALSE);
}
