/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// GLFromUVDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "GLFromUVDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLFromUVDlg _CAO

CGLFromUVDlg::CGLFromUVDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGLFromUVDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGLFromUVDlg)
	m_bNormU = FALSE;
	m_bNormV = FALSE;
	m_dU = 0.0;
	m_dV = 0.0;
	m_strRangeU = _T("");
	m_strRangeV = _T("");
	//}}AFX_DATA_INIT
}

void CGLFromUVDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLFromUVDlg)
	DDX_Check(pDX, IDC_FROM_UV_CHECK_U, m_bNormU);
	DDX_Check(pDX, IDC_FROM_UV_CHECK_V, m_bNormV);
	DDX_Text(pDX, IDC_FROM_UV_EDIT_U, m_dU);
	DDX_Text(pDX, IDC_FROM_UV_EDIT_V, m_dV);
	DDX_Text(pDX, IDC_FROM_UV_STATIC_U, m_strRangeU);
	DDX_Text(pDX, IDC_FROM_UV_STATIC_V, m_strRangeV);
	//}}AFX_DATA_MAP

	if(m_bNormU){
		DDV_MinMaxDouble(pDX, m_dU, 0, 1);
	}
	else{
		DDV_MinMaxDouble(pDX, m_dU, m_dLowerU, m_dUpperU);
	}

	if(m_bNormV){
		DDV_MinMaxDouble(pDX, m_dV, 0, 1);
	}
	else{
		DDV_MinMaxDouble(pDX, m_dV, m_dLowerV, m_dUpperV);
	}
}

void CGLFromUVDlg::SetCaption(double lower, double upper, bool bSetU){
	CString& str = (bSetU ? m_strRangeU : m_strRangeV);
	str.Format(IDS_FORMAT_FROM_UV, lower, upper);
}

void CGLFromUVDlg::SetLimit(double dLowerU, double dUpperU, double dLowerV, double dUpperV){
	m_dLowerU = dLowerU;
	m_dUpperU = dUpperU;
	m_dLowerV = dLowerV;
	m_dUpperV = dUpperV;
}

BEGIN_MESSAGE_MAP(CGLFromUVDlg, CDialog)
	//{{AFX_MSG_MAP(CGLFromUVDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
