/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno             */
/* All rights reserved.                                             */
/* **************************************************************** */

// GLCoordDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "GLCoordDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLCoordDlg _CAO


CGLCoordDlg::CGLCoordDlg()
	 : CDialog(CGLCoordDlg::IDD, 0),
	   m_mode(CANCEL),
	   m_bDisableRelative(false)
{
	//{{AFX_DATA_INIT(CGLCoordDlg)
	m_radio = 0;
	m_str = "";
	//}}AFX_DATA_INIT
}

void CGLCoordDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLCoordDlg)
	DDX_Radio(pDX, IDC_RADIO_COORD_ABSOLUTE, m_radio);
	DDX_Text(pDX, IDC_EDIT_COORDINATE, m_str);
	//}}AFX_DATA_MAP
}

void CGLCoordDlg::OnCancel(){
	m_mode = CANCEL;
	CDialog::OnCancel();
}

void CGLCoordDlg::OnOK(){
	CDialog::OnOK();
	switch(m_radio){
	case 0:	// [hΒW
		m_mode = WORLD_ABS_3D;
		break;
	case 1:	// [hΒW
		m_mode = WORLD_REL_3D;
		break;
	case 2:	// CPlane ΒW
		m_mode = CPLANE_ABS_3D;
		break;
	case 3:	// CPlane ΒW
		m_mode = CPLANE_REL_3D;
		break;
	case 4:	// CPlane ɍW(x)
		m_mode = CPLANE_POLAR;
		break;
	default:
		m_mode = CANCEL;
	}
}

namespace{
	struct DisableWindow{
		DisableWindow(CWnd* pWnd) : m_parent(pWnd){}

		void operator()(int id){
			CWnd* pWnd = m_parent->GetDlgItem(id);
			ASSERT_VALID(pWnd);
			pWnd->EnableWindow(FALSE);
		}
		CWnd* m_parent;
	};
}

BOOL CGLCoordDlg::OnInitDialog(){
	CDialog::OnInitDialog();

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);
	
	SetDlgItemText(IDC_STATIC_COORD_RECENT, m_strPrevInput);
	GetDlgItem(IDC_STATIC_COORD_RECENT)->ShowWindow(m_strPrevInput.IsEmpty() ? SW_HIDE : SW_SHOW);

	if(m_bDisableRelative){
		int id[] = {
			IDC_RADIO_COORD_RELATIVE,
			IDC_RADIO_COORD_CPLANE_RELATIVE
			};
		std::for_each(id, id + sizeof(id)/sizeof(int), DisableWindow(this));
	}
	return TRUE;
}

// O͍W_CAOɕ\
void CGLCoordDlg::DisplayPrevInputCoord(const MGPosition& posRecent)
{
	CString str;
	switch(posRecent.sdim()){
	case 2:
		VERIFY(str.LoadString(IDS_COORD_DLG_FORMAT_2D));
		m_strPrevInput.Format(str, posRecent[0], posRecent[1]);
		break;
	case 3:
		VERIFY(str.LoadString(IDS_COORD_DLG_FORMAT_3D));
		m_strPrevInput.Format(str, posRecent[0], posRecent[1], posRecent[2]);
		break;
	}
}

#ifdef _DEBUG

void CGLCoordDlg::AssertValid() const{
	CDialog::AssertValid();
}

void CGLCoordDlg::Dump(CDumpContext& dc) const{
//	CDialog::Dump(dc); // ̓`FbNȂƂɂ
}
#endif

BEGIN_MESSAGE_MAP(CGLCoordDlg, CDialog)
	//{{AFX_MSG_MAP(CGLCoordDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
