/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"
#include "mgGL/Color.h"
#include "GLColorComboBox.h"

class MGColor;
class MGPickObjects;

/////////////////////////////////////////////////////////////////////////////
// CGLColorLineAttribPage _CAO

class CGLColorLineAttribPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CGLColorLineAttribPage)

// RXgNV
public:
	CGLColorLineAttribPage();
	virtual ~CGLColorLineAttribPage();

// _CAO f[^
	//{{AFX_DATA(CGLColorLineAttribPage)
	enum { IDD = IDD_PROPPAGE_COLOR_LINE };
	CGLColorComboBox m_cbxColor;
	int m_nStipplePreset;
	//}}AFX_DATA

	BOOL context_color()const{return m_useContextColor;};
	MGColor* CreateColor() const;
	MGColor GetColor()const;

	BOOL context_line_width()const{return m_line_width_context;};
	float getLineWidth()const{return m_fLineWidth;};
	MGLineWidth* CreateLineWidth() const;
	MGLineWidth GetLineWidth() const;

	BOOL context_line_stipple()const{return m_line_stipple_context;};
	MGLineStipple* CreateLineStipple() const;
	MGLineStipple GetLineStipple() const;


	/// 
	void InitAttrib(const MGPickObjects& pobjs, fugenDoc* pDoc);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B

	//{{AFX_VIRTUAL(CGLColorLineAttribPage)
	public:
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	virtual BOOL OnInitDialog();

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CGLColorLineAttribPage)
	afx_msg void OnAttribColorOther();
	afx_msg void OnAttribColor();
	afx_msg void OnBnClickedContextColor();
	afx_msg void OnBnClickedLineAttr();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	// define if the color value be removed to use the context color value
	BOOL m_useContextColor;//True if default is checked.
	int m_nColorId;
	DWORD m_dwColor;
	DWORD m_dwColorOther;
	DWORD m_contextColor;//document's context color used when m_useContextColor=true.

	BOOL m_bCustomStipple;
	BOOL m_line_stipple_context;//True if default is checked.
	int m_iStippleFactor;
	USHORT m_shStipplePattern;

	// Define if context line attributes be employed.
	BOOL m_line_width_context;//True if default is checked.
	float m_fLineWidth;

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B
