/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// GLColorButton.cpp : Cve[V t@C

#include "stdafx.h"
#include "GLColorButton.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLColorButton

CGLColorButton::CGLColorButton() :
	m_clr(::GetSysColor(COLOR_BTNFACE))
{
}

CGLColorButton::~CGLColorButton()
{
}

bool CGLColorButton::ChangeColor(){
	CColorDialog dlg;
	INT_PTR iRet = dlg.DoModal();
	if(IDOK == iRet){
		m_clr = dlg.GetColor();
		Invalidate();
	}
	return IDOK == iRet;
}

// Based on www.geocities.jp/chiakifujimon/ bgcolor/section3_4_src.html
void CGLColorButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct){
	CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);
	CRect rcItem = lpDrawItemStruct->rcItem;
	COLORREF saved = pDC->GetBkColor();
	pDC->FillSolidRect(rcItem, m_clr);
	pDC->SetBkColor(saved);


	pDC->DrawEdge(rcItem, EDGE_RAISED, BF_RECT);

	UINT nState = lpDrawItemStruct->itemState;
	if(nState & ODS_FOCUS){
		if(nState & ODS_SELECTED){ 
			pDC->DrawEdge(rcItem, EDGE_SUNKEN, BF_RECT);
		}
		CRect rcFocus = rcItem;
		rcFocus.DeflateRect(4, 4, 4, 4);
		pDC->DrawFocusRect(rcFocus);
	}else if(nState & ODS_DISABLED){
  		// 
	}
}

void CGLColorButton::GetColor(MGColor& c) const{
	c=FromCOLORREF(m_clr);
}

void CGLColorButton::SetColor(const MGColor& c){
	m_clr=MGCOLORtoCOLORREF(c);
}

BEGIN_MESSAGE_MAP(CGLColorButton, CButton)
	//{{AFX_MSG_MAP(CGLColorButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
