/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno             */
/* All rights reserved.                                             */
/********************************************************************/

#if !defined(AFX_GLGRIDPROPPANE_H__F929199A_2D5F_4A71_9257_B3A3130C61EC__INCLUDED_)
#define AFX_GLGRIDPROPPANE_H__F929199A_2D5F_4A71_9257_B3A3130C61EC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"
#include "afxwin.h"
#include "GLPropPanel.h"

class MGConstructionPlane;

/////////////////////////////////////////////////////////////////////////////
// CGLCPlanePropPane _CAO

class CGLCPlanePropPane : public CGLPropPane{
// RXgNV
public:
	CGLCPlanePropPane(fugenDoc* pDoc);

// _CAO f[^
	//{{AFX_DATA(CGLCPlanePropPane)

	double	m_dGridMinor[2];
	int		m_nGrid[2];
	bool    m_dirty;
	fugenView* m_targetView;

	// Input the origin and 2 axes as xxx,yyy,zzz
	CString m_CPlaneOrigin, m_CPlaneXAxis, m_CPlaneYAxis;

	//}}AFX_DATA
	
	void set_dirty(bool is_dirty=true){m_dirty=is_dirty;};

	//Set the grid data to default values.
	void OnButtonPropGridDefault();

	//Set the (x,y,z) string into m_CPlaneOrigin.
	void setCPlaneOriginAxesString(const MGPlane& cplane);

// I[o[Ch
	//{{AFX_VIRTUAL(CGLCPlanePropPane)
protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL


// Cve[V
protected:

	//{{AFX_MSG(CGLCPlanePropPane)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	virtual void LoadUserProf();
	virtual BOOL UpdateUserProf();
	virtual void ResetToDefaultUserProf();

	virtual void LoadDocContext();
	virtual BOOL UpdateDocContext();
	virtual void ResetToDefaultDocContext();

public:
	afx_msg void OnBnClickedButtonPropCplaneDefault();
	afx_msg void OnEnUpdateCplane();
};

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_GLGRIDPROPPANE_H__F929199A_2D5F_4A71_9257_B3A3130C61EC__INCLUDED_)
