/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file GLBlendFuncDlg.cpp
 * @brief GLBlendFuncDlg.h ̎
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "GLBlendFuncDlg.h"
#include "SurfCmd/SurfBlendAll.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLBlendFuncDlg _CAO


CGLBlendFuncDlg::CGLBlendFuncDlg(MGSurfBlendAllTool* tool)
: mgModelessDialogue(tool),	m_bModified(false){
	//{{AFX_DATA_INIT(CGLBlendFuncDlg)
	m_slider_u_e = 100;
	m_slider_u_s = 100;
	m_slider_v_e = 100;
	m_slider_v_s = 100;
	m_ue = 1.0;
	m_us = 1.0;
	m_ve = 1.0;
	m_vs = 1.0;
	//}}AFX_DATA_INIT

	Create(IDD_4SLD_DLG);
}


void CGLBlendFuncDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLBlendFuncDlg)
	DDX_Slider(pDX, IDC_SLIDER_U_E, m_slider_u_e);
	DDX_Slider(pDX, IDC_SLIDER_U_S, m_slider_u_s);
	DDX_Slider(pDX, IDC_SLIDER_V_E, m_slider_v_e);
	DDX_Slider(pDX, IDC_SLIDER_V_S, m_slider_v_s);
	DDX_Text(pDX, IDC_EDIT_U_E, m_ue);
	DDV_MinMaxDouble(pDX, m_ue, 0.25, 4.);
	DDX_Text(pDX, IDC_EDIT_U_S, m_us);
	DDV_MinMaxDouble(pDX, m_us, 0.25, 4.);
	DDX_Text(pDX, IDC_EDIT_V_E, m_ve);
	DDV_MinMaxDouble(pDX, m_ve, 0.25, 4.);
	DDX_Text(pDX, IDC_EDIT_V_S, m_vs);
	DDV_MinMaxDouble(pDX, m_vs, 0.25, 4.);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGLBlendFuncDlg, mgModelessDialogue)
	//{{AFX_MSG_MAP(CGLBlendFuncDlg)
	ON_WM_HSCROLL()
	ON_EN_UPDATE(IDC_EDIT_U_E, OnUpdateEdit)
	ON_EN_UPDATE(IDC_EDIT_U_S, OnUpdateEdit)
	ON_EN_UPDATE(IDC_EDIT_V_E, OnUpdateEdit)
	ON_EN_UPDATE(IDC_EDIT_V_S, OnUpdateEdit)
	ON_EN_KILLFOCUS(IDC_EDIT_U_E, OnKillfocusEdit)
	ON_EN_KILLFOCUS(IDC_EDIT_U_S, OnKillfocusEdit)
	ON_EN_KILLFOCUS(IDC_EDIT_V_E, OnKillfocusEdit)
	ON_EN_KILLFOCUS(IDC_EDIT_V_S, OnKillfocusEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGLBlendFuncDlg bZ[W nh

BOOL CGLBlendFuncDlg::PreTranslateMessage(MSG* pMsg) {
	switch(pMsg->message){
	case WM_MOUSEWHEEL:
		return -1;
	}
	return CDialog::PreTranslateMessage(pMsg);
}

BOOL CGLBlendFuncDlg::OnInitDialog(){
	mgModelessDialogue::OnInitDialog();
	CDialog::PostNcDestroy();

	UINT a[4] = {IDC_SLIDER_U_S, IDC_SLIDER_U_E, IDC_SLIDER_V_S, IDC_SLIDER_V_E};
	for(int i = 0; i < 4; i++){
		CSliderCtrl* pSlider = static_cast<CSliderCtrl*>(GetDlgItem(a[i]));
		ASSERT_VALID(pSlider);
		pSlider->SetPos(pSlider->GetRangeMin());
		pSlider->SetRange(25, 400); // 0.25 - 4.00
		pSlider->SetPos(100);
	}	
	return TRUE;
}

void CGLBlendFuncDlg::OnOK(){
	UpdateData();
	mgModelessDialogue::OnOK();
}

void CGLBlendFuncDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar){
	UpdateData();
	m_ue = 0.01 * m_slider_u_e;
	m_us = 0.01 * m_slider_u_s;
	m_ve = 0.01 * m_slider_v_e;
	m_vs = 0.01 * m_slider_v_s;
	UpdateData(FALSE);

	m_bModified = true;
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
	UpdateView();
}

void CGLBlendFuncDlg::OnUpdateEdit(){
	m_bModified = true;
}

void CGLBlendFuncDlg::OnKillfocusEdit(){
	UpdateData();
	m_slider_u_e = int(100.*m_ue);
	m_slider_u_s = int(100.*m_us);
	m_slider_v_e = int(100.*m_ve);
	m_slider_v_s = int(100.*m_vs);
	UpdateView();
}

void CGLBlendFuncDlg::UpdateView(){
	if( m_bModified){
		UpdateData(FALSE);
		getSurfBlendAllToolPointer()->draw_temporary();
	}
	m_bModified = false;
}

MGSurfBlendAllTool* CGLBlendFuncDlg::getSurfBlendAllToolPointer(){
	return static_cast<MGSurfBlendAllTool*>(getCmdTool());
}
