/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file GLBlendDlg.cpp
 * @brief GLBlendDlg.h ̎
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "GLBlendDlg.h"
#include "SurfCmd/SurfBlendAcross.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLBlendDlg _CAO


CGLBlendDlg::CGLBlendDlg(
double mag[2],	bool& continuous, MGSurfBlendAcrossTool* tool
): mgModelessDialogue(tool)
, m_mag(mag), m_continuous(continuous){
	//{{AFX_DATA_INIT(CGLBlendDlg)
	m_slider_ue = 100;
	m_slider_us = 100;
	//}}AFX_DATA_INIT
	Create(IDD_BLEND_DLG);
}

void CGLBlendDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLBlendDlg)
	DDX_Text(pDX, IDC_EDIT_U_S, m_mag[0]);
	DDV_MinMaxDouble(pDX, m_mag[0], 0.25, 4.);
	DDX_Text(pDX, IDC_EDIT_U_E, m_mag[1]);
	DDV_MinMaxDouble(pDX, m_mag[1], 0.25, 4.);
	DDX_Slider(pDX, IDC_SLIDER_U_E, m_slider_ue);
	DDX_Slider(pDX, IDC_SLIDER_U_S, m_slider_us);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_BLENDACROSS_CONTINUOUS, m_continuousEdge);
}


BEGIN_MESSAGE_MAP(CGLBlendDlg, mgModelessDialogue)
	//{{AFX_MSG_MAP(CGLBlendDlg)
	ON_WM_HSCROLL()
	ON_EN_UPDATE(IDC_EDIT_U_E, OnUpdateEdit)
	ON_EN_UPDATE(IDC_EDIT_U_S, OnUpdateEdit)
	ON_EN_KILLFOCUS(IDC_EDIT_U_E, OnKillfocusEdit)
	ON_EN_KILLFOCUS(IDC_EDIT_U_S, OnKillfocusEdit)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BLENDACROSS_CONTINUOUS, &CGLBlendDlg::OnBnClickedContinuousEdge)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGLBlendDlg bZ[W nh

BOOL CGLBlendDlg::PreTranslateMessage(MSG* pMsg){
	switch(pMsg->message){
	case WM_MOUSEWHEEL:
		return -1;
	}
	return CDialog::PreTranslateMessage(pMsg);
}

BOOL CGLBlendDlg::OnInitDialog(){
	mgModelessDialogue::OnInitDialog();

	UINT a[2] = {IDC_SLIDER_U_S, IDC_SLIDER_U_E};
	for(int i = 0; i < 2; i++){
		CSliderCtrl* pSlider = static_cast<CSliderCtrl*>(GetDlgItem(a[i]));
		ASSERT_VALID(pSlider);
		pSlider->SetPos(pSlider->GetRangeMin());
		pSlider->SetRange(25, 400); // 0.25 - 4.00
		pSlider->SetPos(100);
	}
	return TRUE;
}

void CGLBlendDlg::OnOK(){
	UpdateData();
	mgModelessDialogue::OnOK();
}

void CGLBlendDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	UpdateData();
	m_mag[0] = 0.01 * m_slider_us;
	m_mag[1] = 0.01 * m_slider_ue;
	UpdateData(FALSE);

	m_bModified = true;
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
	UpdateView();
}

void CGLBlendDlg::OnUpdateEdit(){
	m_bModified = true;
}

void CGLBlendDlg::OnKillfocusEdit(){
	UpdateData();
	m_slider_us = int(100.*m_mag[0]);
	m_slider_ue = int(100.*m_mag[1]);
	UpdateView();
}

void CGLBlendDlg::UpdateView(){
	if(m_bModified){
		UpdateData(FALSE);
		m_continuousEdge.SetCheck(m_continuous);
		getCmdTool()->draw_temporary();
	}
	m_bModified = false;
}

void CGLBlendDlg::OnBnClickedContinuousEdge(){
	m_continuous = !m_continuous;
	m_bModified = true;
	UpdateView();
}

MGSurfBlendAcrossTool* CGLBlendDlg::getSurfBlendAcrossToolPointer(){
	return static_cast<MGSurfBlendAcrossTool*>(getCmdTool());
}
