/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file ExportTool.h
 * @brief NX MGExportTool ̐錾
 */
#pragma once

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

/// @class MGExportTool ExportTool.h "FileCmd/ExportTool.h"
/// uIIuWFNgGNX|[gṽR}hNX
class MGExportTool : public MGCommandStateOwner
{
	MGPickObjects m_target;

public:
	explicit MGExportTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;

	virtual bool initiate_tool();

	const MGPickObjects& GetTarget() const;
	void SetTarget(const MGPickObjects& target);
};

/// @class MGExportSelectState
/// MGExport ̃wp[NX
///
/// dl file-export.doc ̏ [S1] ɑB
class MGExportSelectState : public MGSelectState
{
public:
	explicit MGExportSelectState(MGExportTool* pOwnerTool);

	virtual bool initiate_tool();

	// Enter L[gbvB
	virtual bool OnKeyDown(fugenView* pView, UINT nChar,UINT nRepCnt, UINT nFlags);

private:
	MGExportTool* state_owner()
	{
		return static_cast<MGExportTool*>(get_owner_command());
	}
};

/// @class MGExportSaveState
/// MGExport ̃wp[NX
///
/// dl file-export.doc ̏ [S2] ɑB
class MGExportSaveState : public MGCommandBase
{
public:
	explicit MGExportSaveState(MGExportTool* pOwnerTool);

	virtual bool initiate_tool();

private:
	MGExportTool* state_owner()
	{
		return static_cast<MGExportTool*>(get_owner_command());
	}

	bool execute();
};
