/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// EvalSurfUVDiplay.h: MGEvalSurfUVDisplayTool NX̃C^[tFCX
#pragma once

#include "mg/SBRep.h"
#include "mg/PickObjectSB.h"
#include "Common/SelectState.h"
#include "Common/LocateOnObjects.h"
#include "Common/CommandStateOwner.h"

// class MGEvalSurfUVDisplayTool
// Displays a UV value of surface.
class MGEvalSurfUVDisplayTool : public MGCommandStateOwner{
public:
	explicit MGEvalSurfUVDisplayTool(fugenDoc*);
	virtual ~MGEvalSurfUVDisplayTool();

	virtual bool can_break_into() const;
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnCommandEnd(
		UINT nIDS,
		bool erase_temporary_display=true
	);

	//J[\Ɩʂ̌_߂ăof[^ɃZbg
	//́FJ[\wʒuC̃r[
	//óF_̍W_CAÕf[^ɃZbg
	bool calculate(const MGLocateInfo& info);

	bool IsCreateMode() const{ return m_bCreate; }
	void ToggleCreateMode();

	bool IsNormalizeMode() const{ return m_bNormalize; }
	void ToggleNormalizeMode(){ m_bNormalize = !m_bNormalize; }

	void prompt_message() const;

private:
	friend class MGSurfUVLocate;
	friend class MGSurfUVDisplaySSurf;

	MGPosition m_pos;
	MGPosition m_uv;

	const MGFSurface* m_surf; // \ΏۂSurface
	bool m_bCreate; // ɓ_쐬邩
	bool m_bNormalize;// UV W𐳋Kĕ\邩
};

//MGSurfUVDisplaySSurf
//Ȗʂ̑Is
class MGSurfUVDisplaySSurf : public MGSelectState{
public:
	MGSurfUVDisplaySSurf(MGEvalSurfUVDisplayTool* owner);

	MGEvalSurfUVDisplayTool* state_owner(){
		return static_cast<MGEvalSurfUVDisplayTool*>(get_owner_command());
	}

	virtual bool initiate_tool();

	virtual bool OnKeyDown(
		fugenView* window,
		UINT nChar, UINT nRepCnt, UINT nFlags);

	virtual bool OnSelected(
		fugenView* window,
		MGPickObjects& objs,
		MGPickObjects& unselected_objects);
};

//MGSurfUVLocate
//}EXсCJ[\̈ʒu擾
class MGSurfUVLocate : public MGLocateOnObjects{
public:
	MGSurfUVLocate(MGEvalSurfUVDisplayTool* owner, const MGFSurface* surf);

	MGEvalSurfUVDisplayTool* state_owner(){
		return static_cast<MGEvalSurfUVDisplayTool*>(get_owner_command());
	}
	const MGEvalSurfUVDisplayTool* state_owner()const{
		return static_cast<const MGEvalSurfUVDisplayTool*>(get_owner_command());
	}
	bool OnCommandEnd(
		UINT nIDS,
		bool erase_temporary_display=true
	){ return MGLocateOnObjects::OnCommandEnd(nIDS,false);}

	virtual bool OnKeyDown(
		fugenView* window,
		UINT nChar, UINT nRepCnt, UINT nFlags);

	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
	void prompt_message()const;

	virtual bool initiate_tool();
};
