/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// EvalSnapPointsTool.h: MGEvalSnapPointsTool NX̃C^[tFCX

#if !defined(AFX_EvalSnapPointsTOOL_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_)
#define AFX_EvalSnapPointsTOOL_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"
#include "mgGL/SysGL.h"

// class MGEvalSnapPointsTool
//
// Measures a curve curvature.
class MGEvalSnapPointsTool : public MGSelectState{
public:
	explicit MGEvalSnapPointsTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;

	virtual bool can_break_into()const{return true;};
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);

	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	selected_objects,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

	void draw_snaps(
		const MGPickObjects& objs
	);
};

class MGEvalSnapPointsToolSysGL: public mgSysGL{

public:
	MGEvalSnapPointsToolSysGL(
		const MGGel* obj,
		const MGSnapAttrib& snap_attrib
		):mgSysGL(ID_EVAL_SNAP_DISPLAY_ON,obj),m_snap_attrib(snap_attrib){;};

	//Construct new object by copying to newed area.
	//User must delete this copied object by "delete".
	virtual mgSysGL* clone()const;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();

private:
	MGSnapAttrib m_snap_attrib;

};

#endif // !defined(AFX_EvalSnapPointsTOOL_H__2646ECEF_3452_48C9_9170_F07A7330F5C0__INCLUDED_)
