/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// EvalPoint.cpp: MGEvalPointTool NX̃Cve[V

#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "EvalCmd/EvalPoint.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGEvalPointTool

MGEvalPointTool::MGEvalPointTool(fugenDoc* pDoc)
:MGLocateState(pDoc,ID_EVAL_POINT,NO_RUBBER,NO_IPDRAW){}

MGCommandBase* MGEvalPointTool::initial_clone(fugenDoc* pDoc)const{
	return new MGEvalPointTool(pDoc);
}

bool MGEvalPointTool::initiate_tool(){
	MGLocateState::initiate_tool();
	SetStatusMessage(IDS_PROMPT_EVAL_POINT);
	return false;
}

bool MGEvalPointTool::OnLocated(const MGLocateInfo& info){
	const MGConstructionPlane& cpl=info.window()->cplane();
	const MGPosition& wcoord=info.point_world();

	// V[WnHł̍WvZB
	MGPosition ccoord = cpl.convert_from_world(wcoord);

	// [hWnƃV[Wn̗o͂B
	CString str;
	str.Format(
		IDS_FORMAT_RESULT_EVAL_POINT,
		wcoord[0], wcoord[1], wcoord[2],
		ccoord[0], ccoord[1], ccoord[2]);

	// o̓EBhEɏoB
	putInOutputWindow(str);
	return OnCommandEnd(1);
}
