/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalKnots.cpp: MGEvalKnotsTool NX̃Cve[V

#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "EvalCmd/EvalKnotsTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGEvalKnotsTool

MGEvalKnotsTool::MGEvalKnotsTool(fugenDoc* pDoc)
: MGSelectState(pDoc,ID_SYSD_KNOTS,MULTIPLE_SELECT,mgAll_Curve){}

void MGEvalKnotsTool::draw_knots(const MGPickObjects& objs)
{
	size_t n=objs.size();
	for(size_t i=0; i<n; i++){
		draw_temporary(new MGEvalKnotsToolSysGL(objs[i].top_object()),false,false);
	}
	InvalidateAllStdViews();
}

MGCommandBase* MGEvalKnotsTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGEvalKnotsTool(pDoc);
}

bool MGEvalKnotsTool::initiate_tool(){
	MGSelectState::initiate_tool();
	const MGPickObjects& cobjs=current_objects();
	if(is_breaking_command()){
		MGPickObjects curves;
		cobjs.select_curves(curves);
		draw_knots(curves);
		return true;
	}

	int nth=1;
	if(resetCurrentObjects(mgAll_Curve)){
		draw_knots(cobjs);
	}
	SetStatusMessage(IDS_PROMPT_CURVE);
	return false;
}

bool MGEvalKnotsTool::OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display
){
	return MGSelectState::OnCommandEnd(1,false);//Knot display stays displayed.
}

bool MGEvalKnotsTool::OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	selected_objects,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
){
	size_t nUnsel = unselected_objects.size();
	if(nUnsel){
		for(size_t i=0; i<nUnsel; i++){
			erase_temporary(unselected_objects[i].top_object(),false);
		}
		InvalidateAllStdViews();
	}else{
		draw_knots(selected_objects);
	}

	return false;
}

//Construct new object by copying to newed area.
//User must delete this copied object by "delete".
mgSysGL* MGEvalKnotsToolSysGL::clone()const{
	return new MGEvalKnotsToolSysGL(*this);
}

//Draw this Sysgl.
//This draw is used to draw the pictures for Undo(, Redo) operations.
void MGEvalKnotsToolSysGL::drawSysGL(){
	MGColor::get_instance(MGColor::Magenta).exec(*this);
	auto obj = dynamic_cast<const MGObject*>(object_id());
	if(obj) obj->display_break_points(*this);
}
