/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalDistanceTool.h: MGEvalDistanceTool NX̃C^[tFCX

#if !defined(AFX_EVALDISTANCETOOL_H__8845CFC4_3F5D_4EA0_88F4_2EF5B296CD5C__INCLUDED_)
#define AFX_EVALDISTANCETOOL_H__8845CFC4_3F5D_4EA0_88F4_2EF5B296CD5C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mgGL/Sys2GL.h"
#include "Common/SelectState.h"

// class MGEvalDistanceTool
//
// Measures the distance between two objects.
class MGEvalDistanceTool : public MGSelectState{
public:
	explicit MGEvalDistanceTool(fugenDoc* pDoc);
	virtual bool can_break_into()const{return true;};
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);
};

class MGEvalDistanceSysGL: public mgSys2GL{
public:
	MGEvalDistanceSysGL(const MGObject* obj1, const MGObject* obj2);
	const MGObject* object1()const{return dynamic_cast<const MGObject*>(gel1());};
	const MGObject* object2()const{return  dynamic_cast<const MGObject*>(gel2());};

	//Construct new object by copying to newed area.
	//User must delete this copied object by "delete".
	virtual mgSysGL* clone()const;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();

};

#endif // !defined(AFX_EVALDISTANCETOOL_H__8845CFC4_3F5D_4EA0_88F4_2EF5B296CD5C__INCLUDED_)
