/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalDirectionTool.cpp: MGEvalDirectionTool NX̃Cve[V

#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "EvalCmd/EvalDirectionTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGEvalDirectionTool

MGEvalDirectionTool::MGEvalDirectionTool(fugenDoc* pDoc)
:MGSelectState(pDoc,ID_EVAL_ARROW_ON,MULTIPLE_SELECT,mgAll_Object){}

//Draw arrrows of the current objects.
//Function's return value is true if some are drawn, false if not.
bool MGEvalDirectionTool::draw_arrows(
	const MGPickObjects& objs
){
	size_t n=objs.size();
	for(size_t i=0; i<n; i++){
		const MGGel* gel=objs[i].top_object();
		erase_temporary(gel,false);
		draw_temporary(new MGEvalDirectionToolSysGL(gel),false,false);
	}
	InvalidateAllStdViews();
	return n>=1;
}

MGCommandBase* MGEvalDirectionTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGEvalDirectionTool(pDoc);
}

bool MGEvalDirectionTool::initiate_tool(){
	MGSelectState::initiate_tool();
	if(draw_arrows(current_objects()))
		return MGSelectState::OnCommandEnd(1,false);//Curvature display stays displayed.

	if(is_breaking_command())
		return true;

	// Selection message.
	SetStatusMessage(IDS_PROMPT_OBJECT);
	return false;
}

bool MGEvalDirectionTool::OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display
){
	return MGSelectState::OnCommandEnd(1,false);//Curvature display stays displayed.
}

bool MGEvalDirectionTool::OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	selected_objects,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
){
	if(unselected_objects.size()){
		size_t n=unselected_objects.size();
		for(size_t i=0; i<n; i++){
			erase_temporary(unselected_objects[i].top_object());
		}
	}else{
		draw_arrows(selected_objects);
	}
	return MGSelectState::OnCommandEnd(1,false);//Curvature display stays displayed.
}

//Construct new object by copying to newed area.
//User must delete this copied object by "delete".
mgSysGL* MGEvalDirectionToolSysGL::clone()const{
	return new MGEvalDirectionToolSysGL(*this);
}

//Draw this Sysgl.
//This draw is used to draw the pictures for Undo(, Redo) operations.
void MGEvalDirectionToolSysGL::drawSysGL(){
	MGColor::get_instance(MGColor::White).exec(*this);
	auto obj = dynamic_cast<const MGObject*>(object_id());
	if(obj) obj->display_arrows(*this);
}
