/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file EvalCurveRadius.cpp
 * @brief EvalCurveRadius.h 
 */
#include "stdafx.h"
#include "mg/Ellipse.h"
#include "fugenView.h"
#include "Calc/mgcalc.h"
#include "Calc/line.h"
#include "EvalCmd/EvalCurveRadius.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

MGEvalCurveRadiusTool::MGEvalCurveRadiusTool(fugenDoc* pDoc)
: MGLocateState(pDoc, ID_RADIUS, NO_RUBBER, NO_IPDRAW){
	// J[unS
	turn_on_near();
	turn_on_end();
}

///Invoked when command is to terminate as a nomal end.
///display normal end message.
bool MGEvalCurveRadiusTool::OnCommandEnd(
	UINT nIDS,
	bool erase_temporary_display
){
	return MGLocateState::OnCommandEnd(nIDS,false);
}


MGCommandBase* MGEvalCurveRadiusTool::initial_clone(fugenDoc* pDoc)const{
	return new MGEvalCurveRadiusTool(pDoc);
}

bool MGEvalCurveRadiusTool::initiate_tool(){
	MGLocateState::initiate_tool();
	clear_pick_object();
	SetStatusMessage(IDS_PROMPT_EVAL_CURVE_RADIUS);
	return false;
}

bool MGEvalCurveRadiusTool::OnLocated(const MGLocateInfo& info){
	std::unique_ptr<MGEllipse> circle;
	std::unique_ptr<MGCurve> line;
	UpdatePreviewData(circle,line);
	if(!circle.get()){
		return false;
	}
	draw_temporary();

	const double dRadius = circle->radius();
	CString str;
	str.Format(IDS_EVAL_CURVE_RADIUS_RESULT, dRadius);
	putInOutputWindow(str);
	return OnCommandEnd(1,false);
}

/// locate ꂽcircle  line ߂
void MGEvalCurveRadiusTool::UpdatePreviewData(
		std::unique_ptr<MGEllipse>& circle,
		std::unique_ptr<MGCurve>& line
){
	// ȂNAB
	circle.reset(0);
	line.reset(0);

	const MGCurve* pCurve = snappedCurve();
	if(!pCurve){
		return;
	}

	// }EXł߂Ȑ̓_̑Ήp[^[
	double dParam = m_located_param[0];

	// ȗ~vZB
	MGVector T, N, B;
	double curva, torsion;
	MGPosition pos = pCurve->eval(dParam);
	pCurve->Frenet_frame(dParam, T, N, B, curva, torsion);
	if(MGMZero(curva)){
		return;
	}

	const double dRadius = 1./curva;
	circle.reset(new MGEllipse(pos + N * dRadius, dRadius, B));

	// ڐB
	line.reset(mgcalc::create_line(pos, pos + T * dRadius, true).release());
}

/// }EXJ[\ʒű߂ɋȐꍇA
/// IɋȐ̋ȗ~]A`悷B
void MGEvalCurveRadiusTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	std::unique_ptr<MGEllipse> circle;
	std::unique_ptr<MGCurve> line;
	UpdatePreviewData(circle,line);
	if(!circle.get() || !line.get()){
		return;
	}

	mgcalc::MGDrawObject drawobj(mgcalc::CreateDrawFunctor(sgl));

	// ܂͋ȗ~`B
	MGColor::get_instance(MGColor::White).exec(sgl);
	drawobj(circle.get());

	// ɐڐ`B
	// TODO: r[̑傫ɂ炸̒ƂB
	MGColor::get_instance(MGColor::White).exec(sgl);
	drawobj(line.get());
}
