/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalCSFold.h: MGEvalCSFoldTool NX̃C^[tFCX

#if !defined(AFX_EVALCSFOLD_H__2B74EA06_D083_4D0F_A79F_2EA5F0819D64__INCLUDED_)
#define AFX_EVALCSFOLD_H__2B74EA06_D083_4D0F_A79F_2EA5F0819D64__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

class MGCurve;
class MGFSurface;

// class MGEvalCSFoldTool
// 
// ȐƋȖʂ̐܂]R}hłB
// Ȑ C ƋȖ S 1_ŋL_A
// ̓_ C ̒[_ł悤ȏꍇ
// ̃R}h͈ӖB
//
// L_ŕ]f[^͎̒ʂF
// - L_̈ʒu
// - L_ɂ C ̐ڃxNg
// - L_ɂ S ̖@xNg
// - ̃xNg
class MGEvalCSFoldTool : public MGCommandStateOwner{
public:
	explicit MGEvalCSFoldTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool can_break_into()const{return true;};

private:
	bool evaluate();

	void displayInfoOnMessageBox(
		const MGFSurface& surf,
		const MGPosition& uv,
		const MGCurve& curve,
		double t
	);

	MGPickObject m_pocurve;// v邽߂̋Ȑ
	MGPickObject m_posurf;// v邽߂̋Ȗ
	//const MGCurve*    m_curve;  // ܂vȐ
	//const MGFSurface* m_surf;   // surface or face

	friend class MGEvalCSFoldSCurve;
	friend class MGEvalCSFoldSSurf;
};

// class MGEvalCSFoldSCurve
//
// Ȑ{Istate
class MGEvalCSFoldSCurve : public MGSelectState{
public:
	MGEvalCSFoldSCurve(MGCommandStateOwner* owner);
	MGEvalCSFoldTool* state_owner(){
		return static_cast<MGEvalCSFoldTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

// class MGEvalCSFoldSSurf
//
// ȖʂЂƂIstate
class MGEvalCSFoldSSurf : public MGSelectState{
public:
	MGEvalCSFoldSSurf(MGCommandStateOwner* owner);
	MGEvalCSFoldTool* state_owner(){
		return static_cast<MGEvalCSFoldTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

#endif // !defined(AFX_EVALCSFOLD_H__2B74EA06_D083_4D0F_A79F_2EA5F0819D64__INCLUDED_)
