/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalCSDevTool.h: MGEvalCSDevTool NX̃C^[tFCX

#if !defined(AFX_EVALCSDEVTOOL_H__1EC223A1_C0D3_4AA7_80BD_89392C970098__INCLUDED_)
#define AFX_EVALCSDEVTOOL_H__1EC223A1_C0D3_4AA7_80BD_89392C970098__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mgGL/Sys2GL.h"
#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

class MGFSurface;

// class MGEvalCSDevTool
//
// Measures the deviation between a curve and a surface/face.
//
// The command may find one or more intervals of overlap between the two, or
// it may report that the objects do not overlap.
// For each overlap interval some deviation distances are reported.
class MGEvalCSDevTool : public MGCommandStateOwner{
public:
	explicit MGEvalCSDevTool(fugenDoc* pDoc);

	void draw_pictures();
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool can_break_into()const{return true;};

private:
	//bool evaluate(fugenView*);

private:
	MGPickObject m_pocurve;// v邽߂̋Ȑ
	MGPickObject m_posurf;// v邽߂̋Ȗ

	friend class MGEvalCSDevSCurve;
	friend class MGEvalCSDevSSurf;
};

// class MGEvalCSDevSCurve
//
// uȐƋȖʂ̗vR}hŁAȐIԂ\NXB
class MGEvalCSDevSCurve : public MGSelectState{
public:
	MGEvalCSDevSCurve(MGCommandStateOwner* owner);
	MGEvalCSDevTool* state_owner(){
		return static_cast<MGEvalCSDevTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

// class MGEvalCSDevSSurf
//
// uȐƋȖʂ̗vR}hŁAȖʂIԂ\NXB
class MGEvalCSDevSSurf : public MGSelectState{
public:
	MGEvalCSDevSSurf(MGCommandStateOwner* owner);
	MGEvalCSDevTool* state_owner(){
		return static_cast<MGEvalCSDevTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

class MGEvalCSDevSysGL: public mgSys2GL{

public:
	MGEvalCSDevSysGL(const MGCurve* curve, const MGFSurface* surf);
	const MGCurve* curve()const;
	const MGFSurface* surf()const;

	//Construct new object by copying to newed area.
	//User must delete this copied object by "delete".
	virtual mgSysGL* clone()const;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();

};


#endif // !defined(AFX_EVALCSDEVTOOL_H__1EC223A1_C0D3_4AA7_80BD_89392C970098__INCLUDED_)
