/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalBoxTool.h: MGEvalBoxTool NX̃C^[tFCX

#if !defined(AFX_EVALBOXTOOL_H__9AC9CEF8_9421_4A8B_A996_4842173F142E__INCLUDED_)
#define AFX_EVALBOXTOOL_H__9AC9CEF8_9421_4A8B_A996_4842173F142E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

// class MGEvalBoxTool
//
// Creates a bounding box objects.
// A rectilinear bounding box object is created that encloses the objects.
// If the objects are contained in a plane parallel to a coordinate system plane, 
// the bounding box is a rectangular polyline.
// Otherwise, a shell box is created.
class MGEvalBoxTool : public MGSelectState{
public:
	explicit MGEvalBoxTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
		//=1: display "xxxx" normally end.
		//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
		);
	virtual bool can_break_into()const{return true;};
};

#endif // !defined(AFX_EVALBOXTOOL_H__9AC9CEF8_9421_4A8B_A996_4842173F142E__INCLUDED_)
