/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalBoxTool.cpp: MGEvalBoxTool NX̃Cve[V

#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "EvalCmd/EvalBoxTool.h"
#include "Calc/surface.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGEvalBoxTool

MGEvalBoxTool::MGEvalBoxTool(fugenDoc* pDoc)
	 : MGSelectState(pDoc,ID_EVAL_BOX,
	 MGSelectState::MULTIPLE_SELECT // multiple pick
){}

MGCommandBase* MGEvalBoxTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGEvalBoxTool(pDoc);
}

bool MGEvalBoxTool::initiate_tool(){
	MGSelectState::initiate_tool();
	MGPickObjects objectives = current_objects();

	// ʂremove
	objectives.remove(mgAll_Plane);
	if(!is_breaking_command())
		set_current_object(objectives);

	if(!objectives.empty() || is_breaking_command()){
		return OnCommandEnd(1,false);
	}else{
		// ŏ̃bZ[W
		SetStatusMessage(IDS_PROMPT_OBJECT);
	}
	return false;
}

bool MGEvalBoxTool::OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display
){
	SetStatusMessage(IDS_PROMPT_COMPUTE);
	CWaitCursor sandglass;

	UINT nids=3;//canceled message.

	MGPickObjects objectives = current_objects();
	objectives.remove(mgAll_Plane);
	if(!objectives.empty()){	
		MGPickObjects::iterator first = objectives.begin(), last = objectives.end();
		MGBox box = MGDefault::empty_box();
		for(; first != last; ++first){
			if((*first)->top_object()){
				box |= (*first)->top_object()->box();
			}
		}

		std::unique_ptr<MGObject> gawa(mgcalc::shell_box(box));
		if(gawa.get()){
			nids=1;//success.
			add_object_to_current_group(gawa.release());
		}
	}
	return MGSelectState::OnCommandEnd(nids,false);//Box pictures stay displayed.
}
