/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file TrimTool.h
 * @brief NX MGTrimTool ̐錾
 */
#if !defined(AFX_TRIMTOOL_H__8C474FDD_FD31_4670_8608_AD6CBA994197__INCLUDED_)
#define AFX_TRIMTOOL_H__8C474FDD_FD31_4670_8608_AD6CBA994197__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

/// @class MGTrimTool TrimTool.h "EditCmd/TrimTool.h"
///
/// Trims an object.
/// Curves and surfaces can be trimmed with curves, surfaces, faecs.
///
/// When you trim a surface with a curve in a plane parallel view 
/// like the fugenView2Dxy, fugenView2Dyz, and fugenView2Dxz view, 
/// the cutting curve is projected onto the surface in the view direction.
///
/// When you trim a surface with a 3-D curve in an angled parallel
/// or a perspective view, the cutting curve is projected onto the surface
/// normally.
///
/// @note dl doc/edit-trim.doc ɂB
class MGTrimTool : public MGCommandStateOwner
{
	/// gɎgIuWFNg(Trimmer)
	//@{
	MGPickObjects m_Ctrimmers; ///< MGCurve: surfĝƂĎgp
	MGPickObjects m_Strimmers; ///< MGFSurface: gIuWFNgƂĎgp
	//@}

	/// R}hIvV
	//@{
	bool m_bExtend; ///< Jb^[J[u̗[KX邩B
	bool m_bApparent; ///< zWbNKp邩B
	bool m_bExtract;///<true=oAfalse=trim
	//@}

public:
	explicit MGTrimTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);

	enum OptionName{
		EXTEND,
		APPARENT,
		EXTRACT
	};
	bool IsExtract()const{return m_bExtract;};
	bool IsEnabled(OptionName opt) const;
	void ToggleExtendOption();
	void ToggleApparentOption();
	void ToggleExtractOption();

	void prompt_message(UINT nIDS)const;

	/// IIuWFNg̎dsB
	/// @return ؒfIuWFNg`ł true ԂB
	///
	/// 1. ؒfIuWFNgƂĕsKȃ^Cv̂̂IIuWFNg珜OB
	/// 2. ̃NX̃o[f[^KXZbgB
	bool FilterForTrimmer();

	/// ^[QbgɐؒfIuWFNg܂܂Ă΂OB
	/// @param [in,out] target gΏۃIuWFNgB
	void ExcludeTrimmer(MGPickObjects& target);

	/// gsB
	/// @param[in] target g^[QbgB
	/// @param[in] pView gCxgr[B
	/// @return g삪ۂɔ true ԂB
	bool Execute(
		MGPickObject& target,
		fugenView* pView);
};

/// @class MGTrimSelTrimmer
///
/// gɎgIuWFNgI state
/// @note dl [S1] ɑԂ\B
class MGTrimSelTrimmer : public MGSelectState{
public:
	MGTrimSelTrimmer(MGTrimTool* owner);

	MGTrimTool* state_owner(){
		return static_cast<MGTrimTool*>(get_owner_command());
	}
	const MGTrimTool* state_owner()const{
		return static_cast<const MGTrimTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	void prompt_message()const;
};

/// @class MGTrimSelTarget
///
/// gIuWFNgI state
/// @note dl [S2] ɑԂ\B
class MGTrimSelTarget : public MGSelectState{
public:
	MGTrimSelTarget(MGTrimTool* owner);

	MGTrimTool* state_owner(){
		return static_cast<MGTrimTool*>(get_owner_command());
	}
	const MGTrimTool* state_owner()const{
		return static_cast<const MGTrimTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	void prompt_message()const;
};

#endif // !defined(AFX_TRIMTOOL_H__8C474FDD_FD31_4670_8608_AD6CBA994197__INCLUDED_)
