/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file EditDocTreeTool.cpp
 * @brief EditDocTreeTool.h ̎
 */
#include "stdafx.h"
#include "EditCmd/EditDocTreeTool.h"
#include "fugenDocContentDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MGDocTreeTool::MGDocTreeTool(fugenDoc* pDoc)
	 : MGCommandBase(pDoc, ID_EDIT_DOC_CONTENT)
	 , m_current_group(pDoc->current_group())
{
}

MGCommandBase* MGDocTreeTool::initial_clone(fugenDoc* pDoc)const{
	return new MGDocTreeTool(pDoc);
}

bool MGDocTreeTool::initiate_tool(){
	MGCommandBase::initiate_tool();
	SetStatusMessage(IDS_PROMPT_DOC_TREE);

	fugenDocContentDlg dlg(document());
	dlg.DoModal();

	return OnCommandEnd(1);
}

bool MGDocTreeTool::terminate_tool(bool cancel) {
	//őIĂIuWFNgNAAO[vݒ肵Ȃ
	document()->set_current_object();
	document()->set_current_group(m_current_group);

	return MGCommandBase::terminate_tool(cancel);
}
