/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file AttribTool.h
 * @brief NX MGAttribTool ̐錾
 */
#pragma once

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

/// @class MGAttribTool AttribTool.h "EditCmd/AttribTool.h"
/// [ҏWIuWFNg̃vpeB] ̃R}hNXB
class MGAttribTool : public MGCommandStateOwner
{
	MGPickObjects m_target; ///< vpeBҏWΏ

public:
	/// RXgN^[
	/// @param[in] pDoc R}hΏۃhLg
	explicit MGAttribTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

	/// ҏW^[QbgANZX
	//@{
	MGPickObjects& GetTarget();
	void SetTarget(const MGPickObjects& target);
	//@}
};

/// @class MGAttribSelectState
/// MGAttribTool ̃wp[NXBҏWΏۂIB
class MGAttribSelectState : public MGSelectState
{
public:
	/// RXgN^[
	/// @param[in] pOwner ̎qԂeԁB
	explicit MGAttribSelectState(MGAttribTool* pOwner);

	virtual bool initiate_tool();

	virtual bool OnKeyDown(fugenView* window, UINT nChar, UINT nRepCnt, UINT nFlags);

private:
	MGAttribTool* state_owner()
	{
		return static_cast<MGAttribTool*>(get_owner_command());
	}
};

/// @class MGAttribEditState
/// MGAttribTool ̃wp[NXBvf̃vpeB[ҏWB
class MGAttribEditState : public MGCommandBase
{
public:
	/// RXgN^[
	/// @param[in] pOwner ̎qԂeԁB
	explicit MGAttribEditState(MGAttribTool* pOwner);

	virtual bool initiate_tool();

private:
	MGAttribTool* state_owner()
	{
		return static_cast<MGAttribTool*>(get_owner_command());
	}

	bool execute();
};
