/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SplineSketchTool.h
 * @brief MGSplineSketchTool NX̃C^[tFCX
 */
#if !defined(AFX_SPLINESKETCH_H__3874E479_3485_46A1_AB2F_EF804874A6E2__INCLUDED_)
#define AFX_SPLINESKETCH_H__3874E479_3485_46A1_AB2F_EF804874A6E2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

class MGCommandStateOwner;

/// @class MGSplineSketchTool SplineSketchTool.h "CurveCmd/SplineSketchTool.h"
/// 
/// r[}EXŃhbOƁAɃXvC𐶐R}h
class MGSplineSketchTool : public MGLocateState{
public:
	explicit MGSplineSketchTool(fugenDoc* doc);
	MGCommandBase* initial_clone(fugenDoc* pDoc)const;

	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);

	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);

	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLButtonUp(fugenView* pView, CPoint, UINT nFlags, CPoint point);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	void addPointMakeSpline(const MGPosition& point, bool ButtonDown);
	void prompt_message() const;
	std::vector<MGPosition> m_pos;
	std::unique_ptr<MGCurve> m_current;
	std::vector<UniqueCurve> m_tmp; ///< ꎞ`p

	// IvV
	bool m_bClose; ///< Ȑ邩ǂ
	bool m_ButtonDown; ///< }EX{^ÂĂƂ true ƂȂ
};

#endif // !defined(AFX_SPLINESKETCH_H__3874E479_3485_46A1_AB2F_EF804874A6E2__INCLUDED_)
